/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.jibx;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ObjectHelper;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;

public class JibxDataFormat
implements DataFormat {
    private Class unmarshallClass;

    public JibxDataFormat() {
    }

    public JibxDataFormat(Class unmarshallClass) {
        this.setUnmarshallClass(unmarshallClass);
    }

    public void marshal(Exchange exchange, Object body, OutputStream stream) throws Exception {
        IBindingFactory bindingFactory = BindingDirectory.getFactory(body.getClass());
        IMarshallingContext marshallingContext = bindingFactory.createMarshallingContext();
        marshallingContext.marshalDocument(body, null, null, stream);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        ObjectHelper.notNull((Object)this.getUnmarshallClass(), (String)"unmarshallClass");
        IBindingFactory bindingFactory = BindingDirectory.getFactory((Class)this.getUnmarshallClass());
        IUnmarshallingContext unmarshallingContext = bindingFactory.createUnmarshallingContext();
        return unmarshallingContext.unmarshalDocument(stream, null);
    }

    public Class getUnmarshallClass() {
        return this.unmarshallClass;
    }

    public void setUnmarshallClass(Class unmarshallClass) {
        this.unmarshallClass = unmarshallClass;
    }
}

