/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator.jing;

import com.thaiopensource.relaxng.SchemaFactory;
import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.xml.sax.Jaxp11XMLReaderCreator;
import com.thaiopensource.xml.sax.XMLReaderCreator;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.processor.validation.DefaultValidationErrorHandler;
import org.apache.camel.util.ExchangeHelper;
import org.springframework.core.io.Resource;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JingValidator
implements Processor {
    private Schema schema;
    private SchemaFactory schemaFactory;
    private String schemaNamespace = "http://relaxng.org/ns/structure/1.0";
    private Resource schemaResource;
    private InputSource inputSource;
    private boolean compactSyntax;

    public void process(Exchange exchange) throws Exception {
        Jaxp11XMLReaderCreator xmlCreator = new Jaxp11XMLReaderCreator();
        DefaultValidationErrorHandler errorHandler = new DefaultValidationErrorHandler();
        PropertyMapBuilder mapBuilder = new PropertyMapBuilder();
        mapBuilder.put((PropertyId)ValidateProperty.XML_READER_CREATOR, (Object)xmlCreator);
        mapBuilder.put((PropertyId)ValidateProperty.ERROR_HANDLER, (Object)errorHandler);
        PropertyMap propertyMap = mapBuilder.toPropertyMap();
        Validator validator = this.getSchema().createValidator(propertyMap);
        Message in = exchange.getIn();
        SAXSource saxSource = (SAXSource)in.getBody(SAXSource.class);
        if (saxSource == null) {
            Source source = (Source)ExchangeHelper.getMandatoryInBody((Exchange)exchange, Source.class);
            saxSource = (SAXSource)ExchangeHelper.convertToMandatoryType((Exchange)exchange, SAXSource.class, (Object)source);
        }
        InputSource bodyInput = saxSource.getInputSource();
        XMLReader reader = xmlCreator.createXMLReader();
        reader.setContentHandler(validator.getContentHandler());
        reader.setDTDHandler(validator.getDTDHandler());
        reader.setErrorHandler((ErrorHandler)errorHandler);
        reader.parse(bodyInput);
        errorHandler.handleErrors(exchange, (Object)this.schema);
    }

    public Schema getSchema() throws IOException, IncorrectSchemaException, SAXException {
        if (this.schema == null) {
            SchemaFactory factory = this.getSchemaFactory();
            this.schema = factory.createSchema(this.getInputSource());
        }
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public InputSource getInputSource() throws IOException {
        if (this.inputSource == null) {
            Resource resource = this.getSchemaResource();
            if (resource == null) {
                throw new IllegalArgumentException("No schemaResource or inputSource specified");
            }
            InputStream inputStream = resource.getInputStream();
            if (inputStream == null) {
                throw new IllegalArgumentException("No inputStream available for: " + resource);
            }
            this.inputSource = new InputSource(inputStream);
        }
        return this.inputSource;
    }

    public void setInputSource(InputSource inputSource) {
        this.inputSource = inputSource;
    }

    public SchemaFactory getSchemaFactory() {
        if (this.schemaFactory == null) {
            this.schemaFactory = new SchemaFactory();
            this.schemaFactory.setCompactSyntax(this.compactSyntax);
            this.schemaFactory.setXMLReaderCreator((XMLReaderCreator)new Jaxp11XMLReaderCreator());
        }
        return this.schemaFactory;
    }

    public void setSchemaFactory(SchemaFactory schemaFactory) {
        this.schemaFactory = schemaFactory;
    }

    public Resource getSchemaResource() {
        return this.schemaResource;
    }

    public void setSchemaResource(Resource schemaResource) {
        this.schemaResource = schemaResource;
    }

    public String getSchemaNamespace() {
        return this.schemaNamespace;
    }

    public void setSchemaNamespace(String schemaNamespace) {
        this.schemaNamespace = schemaNamespace;
    }

    public boolean isCompactSyntax() {
        return this.compactSyntax;
    }

    public void setCompactSyntax(boolean compactSyntax) {
        this.compactSyntax = compactSyntax;
    }
}

