/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.reply;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.component.jms.reply.CorrelationListener;
import org.apache.camel.component.jms.reply.ReplyHandler;
import org.apache.camel.util.DefaultTimeoutMap;

public class CorrelationMap
extends DefaultTimeoutMap<String, ReplyHandler> {
    private CorrelationListener listener;

    public CorrelationMap(ScheduledExecutorService executor, long requestMapPollTimeMillis) {
        super(executor, requestMapPollTimeMillis);
    }

    public void setListener(CorrelationListener listener) {
        this.listener = listener;
    }

    public boolean onEviction(String key, ReplyHandler value) {
        try {
            if (this.listener != null) {
                this.listener.onEviction(key);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        value.onTimeout(key);
        return true;
    }

    public void put(String key, ReplyHandler value, long timeoutMillis) {
        try {
            if (this.listener != null) {
                this.listener.onPut(key);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (timeoutMillis <= 0L) {
            super.put((Object)key, (Object)value, Integer.MAX_VALUE);
        } else {
            super.put((Object)key, (Object)value, timeoutMillis);
        }
    }

    public ReplyHandler remove(String key) {
        try {
            if (this.listener != null) {
                this.listener.onRemove(key);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        ReplyHandler answer = (ReplyHandler)super.remove((Object)key);
        return answer;
    }
}

