/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.sql;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.RuntimeExpressionException;
import org.apache.camel.util.ObjectHelper;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.QueryParseException;

public class SqlBuilder
implements Expression,
Predicate {
    private Query query;
    private Map<String, Object> variables = new HashMap<String, Object>();

    public SqlBuilder(Query query) {
        this.query = query;
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        List result = this.evaluateQuery(exchange);
        return (T)exchange.getContext().getTypeConverter().convertTo(type, (Object)result);
    }

    public boolean matches(Exchange exchange) {
        List list = this.evaluateQuery(exchange);
        return this.matches(exchange, list);
    }

    public void assertMatches(String text, Exchange exchange) throws AssertionError {
        List list = this.evaluateQuery(exchange);
        if (!this.matches(exchange, list)) {
            throw new AssertionError((Object)(this + " failed on " + exchange + " as found " + list));
        }
    }

    public static SqlBuilder sql(String sql) throws QueryParseException {
        Query q = new Query();
        q.parse(sql);
        return new SqlBuilder(q);
    }

    public SqlBuilder variable(String name, Object value) {
        this.getVariables().put(name, value);
        return this;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> properties) {
        this.variables = properties;
    }

    protected boolean matches(Exchange exchange, List list) {
        return ObjectHelper.matches((List)list);
    }

    protected List evaluateQuery(Exchange exchange) {
        this.configureQuery(exchange);
        Message in = exchange.getIn();
        List<Object> list = (List<Object>)in.getBody(List.class);
        if (list == null) {
            list = Collections.singletonList(in.getBody());
        }
        try {
            return this.query.execute(list).getResults();
        }
        catch (QueryExecutionException e) {
            throw new RuntimeExpressionException((Throwable)e);
        }
    }

    protected void configureQuery(Exchange exchange) {
        this.addVariables(exchange.getProperties());
        this.addVariables(exchange.getIn().getHeaders());
        this.addVariables(this.getVariables());
        this.query.setVariable("exchange", (Object)exchange);
        this.query.setVariable("in", (Object)exchange.getIn());
        this.query.setVariable("out", (Object)exchange.getOut());
    }

    protected void addVariables(Map<String, Object> map) {
        Set<Map.Entry<String, Object>> propertyEntries = map.entrySet();
        for (Map.Entry<String, Object> entry : propertyEntries) {
            this.query.setVariable(entry.getKey(), entry.getValue());
        }
    }
}

