/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import java.util.Iterator;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.component.jpa.JpaEndpoint;
import org.apache.camel.component.jpa.TransactionStrategy;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.impl.DefaultProducer;
import org.springframework.orm.jpa.JpaCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaProducer
extends DefaultProducer<Exchange> {
    private final TransactionStrategy template;
    private final JpaEndpoint endpoint;
    private final Expression<Exchange> expression;

    public JpaProducer(JpaEndpoint endpoint, Expression<Exchange> expression) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.expression = expression;
        this.template = endpoint.createTransactionStrategy();
    }

    public void process(Exchange exchange) {
        final Object values = this.expression.evaluate(exchange);
        if (values != null) {
            this.template.execute(new JpaCallback(){

                public Object doInJpa(EntityManager entityManager) throws PersistenceException {
                    Iterator iter = ObjectConverter.iterator((Object)values);
                    while (iter.hasNext()) {
                        Object value = iter.next();
                        entityManager.persist(value);
                    }
                    if (JpaProducer.this.endpoint.isFlushOnSend()) {
                        entityManager.flush();
                    }
                    return null;
                }
            });
        }
        exchange.setProperty("CamelJpaValue", values);
    }
}

