/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import java.util.Iterator;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.component.jpa.JpaEndpoint;
import org.apache.camel.component.jpa.TransactionStrategy;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.springframework.orm.jpa.JpaCallback;

public class JpaProducer
extends DefaultProducer {
    private final TransactionStrategy template;
    private final JpaEndpoint endpoint;
    private final Expression expression;

    public JpaProducer(JpaEndpoint endpoint, Expression expression) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.expression = expression;
        this.template = endpoint.createTransactionStrategy();
    }

    public void process(Exchange exchange) {
        exchange.getIn().setHeader("CamelJpaTemplate", (Object)this.endpoint.getTemplate());
        final Object values = this.expression.evaluate(exchange, Object.class);
        if (values != null) {
            this.template.execute(new JpaCallback(){

                public Object doInJpa(EntityManager entityManager) throws PersistenceException {
                    Iterator iter = ObjectHelper.createIterator((Object)values);
                    while (iter.hasNext()) {
                        Object value = iter.next();
                        entityManager.merge(value);
                    }
                    if (JpaProducer.this.endpoint.isFlushOnSend()) {
                        entityManager.flush();
                    }
                    return null;
                }
            });
        }
        exchange.getIn().removeHeader("CamelJpaTemplate");
    }
}

