/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.InvalidPayloadRuntimeException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jpa.JpaComponent;
import org.apache.camel.component.jpa.JpaConsumer;
import org.apache.camel.component.jpa.JpaProducer;
import org.apache.camel.component.jpa.JpaTemplateTransactionStrategy;
import org.apache.camel.component.jpa.TransactionStrategy;
import org.apache.camel.impl.ExpressionAdapter;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.springframework.orm.jpa.JpaTemplate;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaEndpoint
extends ScheduledPollEndpoint {
    private EntityManagerFactory entityManagerFactory;
    private PlatformTransactionManager transactionManager;
    private String persistenceUnit = "camel";
    private JpaTemplate template;
    private Expression producerExpression;
    private int maximumResults = -1;
    private Class<?> entityType;
    private Map<Object, Object> entityManagerProperties;
    private boolean consumeDelete = true;
    private boolean consumeLockEntity = true;
    private boolean flushOnSend = true;
    private int maxMessagesPerPoll;
    private boolean usePersist;

    public JpaEndpoint() {
    }

    public JpaEndpoint(String endpointUri) {
        super(endpointUri);
    }

    public JpaEndpoint(String uri, JpaComponent component) {
        super(uri, (Component)component);
        this.entityManagerFactory = component.getEntityManagerFactory();
        this.transactionManager = component.getTransactionManager();
    }

    public JpaEndpoint(String endpointUri, EntityManagerFactory entityManagerFactory) {
        super(endpointUri);
        this.entityManagerFactory = entityManagerFactory;
    }

    public JpaEndpoint(String endpointUri, EntityManagerFactory entityManagerFactory, PlatformTransactionManager transactionManager) {
        super(endpointUri);
        this.entityManagerFactory = entityManagerFactory;
        this.transactionManager = transactionManager;
    }

    public Producer createProducer() throws Exception {
        this.validate();
        return new JpaProducer(this, this.getProducerExpression());
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        this.validate();
        JpaConsumer consumer = new JpaConsumer(this, processor);
        consumer.setMaxMessagesPerPoll(this.getMaxMessagesPerPoll());
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public void configureProperties(Map<String, Object> options) {
        super.configureProperties(options);
        Map emProperties = IntrospectionSupport.extractProperties(options, (String)"emf.");
        if (emProperties != null) {
            this.setEntityManagerProperties(CastUtils.cast((Map)emProperties));
        }
    }

    public boolean isSingleton() {
        return false;
    }

    protected String createEndpointUri() {
        return "jpa" + (this.entityType != null ? "://" + this.entityType.getName() : "");
    }

    public JpaTemplate getTemplate() {
        if (this.template == null) {
            this.template = this.createTemplate();
        }
        return this.template;
    }

    public void setTemplate(JpaTemplate template) {
        this.template = template;
    }

    public Expression getProducerExpression() {
        if (this.producerExpression == null) {
            this.producerExpression = this.createProducerExpression();
        }
        return this.producerExpression;
    }

    public void setProducerExpression(Expression producerExpression) {
        this.producerExpression = producerExpression;
    }

    public int getMaximumResults() {
        return this.maximumResults;
    }

    public void setMaximumResults(int maximumResults) {
        this.maximumResults = maximumResults;
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    public void setEntityType(Class<?> entityType) {
        this.entityType = entityType;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        if (this.entityManagerFactory == null) {
            this.entityManagerFactory = this.createEntityManagerFactory();
        }
        return this.entityManagerFactory;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public PlatformTransactionManager getTransactionManager() {
        if (this.transactionManager == null) {
            this.transactionManager = this.createTransactionManager();
        }
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public Map<Object, Object> getEntityManagerProperties() {
        if (this.entityManagerProperties == null) {
            this.entityManagerProperties = System.getProperties();
        }
        return this.entityManagerProperties;
    }

    public void setEntityManagerProperties(Map<Object, Object> entityManagerProperties) {
        this.entityManagerProperties = entityManagerProperties;
    }

    public String getPersistenceUnit() {
        return this.persistenceUnit;
    }

    public void setPersistenceUnit(String persistenceUnit) {
        this.persistenceUnit = persistenceUnit;
    }

    public boolean isConsumeDelete() {
        return this.consumeDelete;
    }

    public void setConsumeDelete(boolean consumeDelete) {
        this.consumeDelete = consumeDelete;
    }

    public boolean isConsumeLockEntity() {
        return this.consumeLockEntity;
    }

    public void setConsumeLockEntity(boolean consumeLockEntity) {
        this.consumeLockEntity = consumeLockEntity;
    }

    public boolean isFlushOnSend() {
        return this.flushOnSend;
    }

    public void setFlushOnSend(boolean flushOnSend) {
        this.flushOnSend = flushOnSend;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public boolean isUsePersist() {
        return this.usePersist;
    }

    public void setUsePersist(boolean usePersist) {
        this.usePersist = usePersist;
    }

    protected void validate() {
        ObjectHelper.notNull((Object)this.getEntityManagerFactory(), (String)"entityManagerFactory");
    }

    protected JpaTemplate createTemplate() {
        return new JpaTemplate(this.getEntityManagerFactory());
    }

    protected EntityManagerFactory createEntityManagerFactory() {
        return Persistence.createEntityManagerFactory((String)this.persistenceUnit, this.getEntityManagerProperties());
    }

    protected PlatformTransactionManager createTransactionManager() {
        JpaTransactionManager tm = new JpaTransactionManager(this.getEntityManagerFactory());
        tm.afterPropertiesSet();
        return tm;
    }

    protected EntityManager createEntityManager() {
        return this.getEntityManagerFactory().createEntityManager();
    }

    protected TransactionStrategy createTransactionStrategy() {
        return JpaTemplateTransactionStrategy.newInstance(this.getTransactionManager(), this.getTemplate());
    }

    protected Expression createProducerExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                Object answer;
                try {
                    answer = JpaEndpoint.this.getEntityType() == null ? exchange.getIn().getMandatoryBody() : exchange.getIn().getMandatoryBody(JpaEndpoint.this.getEntityType());
                }
                catch (InvalidPayloadException e) {
                    throw new InvalidPayloadRuntimeException(exchange, JpaEndpoint.this.getEntityType(), e.getCause());
                }
                if (answer == null) {
                    throw new InvalidPayloadRuntimeException(exchange, JpaEndpoint.this.getEntityType());
                }
                return answer;
            }
        };
    }
}

