/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jt400;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.DataQueue;
import java.beans.PropertyVetoException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.CamelException;
import org.apache.camel.Component;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Producer;
import org.apache.camel.component.jt400.Jt400Component;
import org.apache.camel.component.jt400.Jt400DataQueueConsumer;
import org.apache.camel.component.jt400.Jt400DataQueueProducer;
import org.apache.camel.impl.DefaultPollingEndpoint;

public class Jt400DataQueueEndpoint
extends DefaultPollingEndpoint {
    private final AS400 system;
    private final String objectPath;
    private DataQueue dataqueue;
    private Format format = Format.text;

    protected Jt400DataQueueEndpoint(String endpointUri, Jt400Component component) throws CamelException {
        super(endpointUri, (Component)component);
        try {
            URI uri = new URI(endpointUri);
            String[] credentials = uri.getUserInfo().split(":");
            this.system = new AS400(uri.getHost(), credentials[0], credentials[1]);
            this.objectPath = uri.getPath();
        }
        catch (URISyntaxException e) {
            throw new CamelException("Unable to parse URI for " + endpointUri, (Throwable)e);
        }
    }

    public void setCcsid(int ccsid) throws PropertyVetoException {
        this.system.setCcsid(ccsid);
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public Format getFormat() {
        return this.format;
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        return new Jt400DataQueueConsumer(this);
    }

    public Producer createProducer() throws Exception {
        return new Jt400DataQueueProducer(this);
    }

    protected AS400 getSystem() {
        return this.system;
    }

    protected DataQueue getDataQueue() {
        if (this.dataqueue == null) {
            this.dataqueue = new DataQueue(this.system, this.objectPath);
        }
        return this.dataqueue;
    }

    public boolean isSingleton() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        text,
        binary;

    }
}

