/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jt400;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ConnectionPool;
import com.ibm.as400.access.ConnectionPoolException;
import java.beans.PropertyVetoException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jt400.Jt400DataQueueEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Jt400Endpoint {
    private static final Logger LOG = LoggerFactory.getLogger(Jt400Endpoint.class);
    private static final int DEFAULT_SYSTEM_CCSID = -1;
    private final String systemName;
    private final String userID;
    private final String password;
    private final String objectPath;
    private final AS400ConnectionPool connectionPool;
    private int ccsid = -1;
    private Jt400DataQueueEndpoint.Format format = Jt400DataQueueEndpoint.Format.text;
    private boolean guiAvailable;

    Jt400Endpoint(String endpointUri, AS400ConnectionPool connectionPool) throws URISyntaxException {
        ObjectHelper.notNull((Object)endpointUri, (String)"endpointUri", (Object)this);
        ObjectHelper.notNull((Object)connectionPool, (String)"connectionPool", (Object)this);
        URI uri = new URI(endpointUri);
        String[] credentials = uri.getUserInfo().split(":");
        this.systemName = uri.getHost();
        this.userID = credentials[0];
        this.password = credentials[1];
        this.objectPath = uri.getPath();
        this.connectionPool = connectionPool;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public String getUserID() {
        return this.userID;
    }

    public String getPassword() {
        return this.password;
    }

    public String getObjectPath() {
        return this.objectPath;
    }

    public int getCssid() {
        return this.ccsid;
    }

    public void setCcsid(int ccsid) {
        this.ccsid = ccsid < 0 ? -1 : ccsid;
    }

    public Jt400DataQueueEndpoint.Format getFormat() {
        return this.format;
    }

    public void setFormat(Jt400DataQueueEndpoint.Format format) {
        ObjectHelper.notNull((Object)((Object)format), (String)"format", (Object)this);
        this.format = format;
    }

    public boolean isGuiAvailable() {
        return this.guiAvailable;
    }

    public void setGuiAvailable(boolean guiAvailable) {
        this.guiAvailable = guiAvailable;
    }

    public AS400 getConnection() {
        AS400 system = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Getting an AS400 object for '{}' from {}.", (Object)(this.systemName + '/' + this.userID), (Object)this.connectionPool);
            }
            system = this.connectionPool.getConnection(this.systemName, this.userID, this.password);
            if (this.ccsid != -1) {
                system.setCcsid(this.ccsid);
            }
            try {
                system.setGuiAvailable(this.guiAvailable);
            }
            catch (PropertyVetoException e) {
                LOG.warn("Failed to disable AS/400 prompting in the environment running Camel. This exception will be ignored.", (Throwable)e);
            }
            return system;
        }
        catch (ConnectionPoolException e) {
            throw new RuntimeCamelException(String.format("Unable to obtain an AS/400 connection for system name '%s' and user ID '%s'", this.systemName, this.userID), (Throwable)e);
        }
        catch (PropertyVetoException e) {
            throw new RuntimeCamelException("Unable to set the CSSID to use with " + system, (Throwable)e);
        }
    }

    public void releaseConnection(AS400 connection) {
        ObjectHelper.notNull((Object)connection, (String)"connection", (Object)this);
        this.connectionPool.returnConnectionToPool(connection);
    }
}

