/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jt400;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.jt400.Jt400DataQueueEndpoint;
import org.apache.camel.component.jt400.Jt400PgmCallException;
import org.apache.camel.component.jt400.Jt400PgmEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jt400PgmProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(Jt400PgmProducer.class);
    private AS400 iSeries;

    public Jt400PgmProducer(Jt400PgmEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    private Jt400PgmEndpoint getISeriesEndpoint() {
        return (Jt400PgmEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String commandStr = this.getISeriesEndpoint().getProgramToExecute();
        ProgramParameter[] parameterList = this.getParameterList(exchange);
        ProgramCall pgmCall = new ProgramCall(this.iSeries);
        pgmCall.setProgram(commandStr);
        pgmCall.setParameterList(parameterList);
        if (LOG.isDebugEnabled()) {
            LOG.trace("Starting to call PGM '{}' in host '{}' authentication with the user '{}'", new Object[]{commandStr, this.iSeries.getSystemName(), this.iSeries.getUserId()});
        }
        boolean result = pgmCall.run();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Executed PGM '{}' in host '{}'. Success? {}", new Object[]{commandStr, this.iSeries.getSystemName(), result});
        }
        if (!result) {
            throw new Jt400PgmCallException(this.getOutputMessages(pgmCall));
        }
        this.handlePGMOutput(exchange, pgmCall, parameterList);
    }

    private ProgramParameter[] getParameterList(Exchange exchange) throws InvalidPayloadException, PropertyVetoException {
        Object body = exchange.getIn().getMandatoryBody();
        Object[] params = (Object[])body;
        ProgramParameter[] parameterList = new ProgramParameter[params.length];
        for (int i = 0; i < params.length; ++i) {
            boolean input;
            boolean output;
            Object param = params[i];
            if (this.getISeriesEndpoint().isFieldIdxForOuput(i)) {
                output = true;
                input = param != null;
            } else {
                output = false;
                input = true;
            }
            byte[] inputData = null;
            int length = this.getISeriesEndpoint().getOutputFieldLength(i);
            if (input && param != null) {
                Object typeConverter = this.getISeriesEndpoint().getFormat() == Jt400DataQueueEndpoint.Format.binary ? new AS400ByteArray(length) : new AS400Text(length, this.iSeries);
                inputData = typeConverter.toBytes(param);
            }
            if (input && output) {
                LOG.trace("Parameter {} is both input and output.", (Object)i);
                parameterList[i] = new ProgramParameter(inputData, length);
                continue;
            }
            if (input) {
                LOG.trace("Parameter {} is input.", (Object)i);
                if (inputData != null) {
                    parameterList[i] = new ProgramParameter(inputData);
                    continue;
                }
                parameterList[i] = new ProgramParameter();
                parameterList[i].setParameterType(2);
                parameterList[i].setNullParameter(true);
                continue;
            }
            LOG.trace("Parameter {} is output.", (Object)i);
            parameterList[i] = new ProgramParameter(length);
        }
        return parameterList;
    }

    private void handlePGMOutput(Exchange exchange, ProgramCall pgmCall, ProgramParameter[] inputs) throws InvalidPayloadException {
        Object body = exchange.getIn().getMandatoryBody();
        Object[] params = (Object[])body;
        ArrayList<Object> results = new ArrayList<Object>();
        int i = 1;
        for (ProgramParameter pgmParam : pgmCall.getParameterList()) {
            byte[] output = pgmParam.getOutputData();
            Object javaValue = params[i - 1];
            if (output != null) {
                int length = pgmParam.getOutputDataLength();
                Object typeConverter = this.getISeriesEndpoint().getFormat() == Jt400DataQueueEndpoint.Format.binary ? new AS400ByteArray(length) : new AS400Text(length, this.iSeries);
                javaValue = typeConverter.toObject(output);
            }
            results.add(javaValue);
            ++i;
        }
        Object[] bodyOUT = new Object[results.size()];
        bodyOUT = results.toArray(bodyOUT);
        exchange.getOut().setBody((Object)bodyOUT);
    }

    private String getOutputMessages(ProgramCall pgmCall) throws Exception {
        StringBuilder outputMsg = new StringBuilder();
        AS400Message[] messageList = pgmCall.getMessageList();
        for (int i = 0; i < messageList.length; ++i) {
            messageList[i].load();
            outputMsg.append(i + ") ");
            outputMsg.append(messageList[i].getText());
            outputMsg.append(" - ");
            outputMsg.append(messageList[i].getHelp());
            outputMsg.append("\n");
        }
        return outputMsg.toString();
    }

    protected void doStart() throws Exception {
        if (this.iSeries == null) {
            this.iSeries = this.getISeriesEndpoint().getiSeries();
        }
        if (!this.iSeries.isConnected(2)) {
            LOG.info("Connecting to {}", (Object)this.getISeriesEndpoint());
            this.iSeries.connectService(2);
        }
    }

    protected void doStop() throws Exception {
        if (this.iSeries != null) {
            LOG.info("Releasing connection to {}", (Object)this.getISeriesEndpoint());
            this.getISeriesEndpoint().releaseiSeries(this.iSeries);
            this.iSeries = null;
        }
    }
}

