/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jt400;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.DataQueue;
import com.ibm.as400.access.DataQueueEntry;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import java.io.IOException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jt400.Jt400DataQueueEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.PollingConsumerSupport;

public class Jt400DataQueueConsumer
extends PollingConsumerSupport {
    private final Jt400DataQueueEndpoint endpoint;

    protected Jt400DataQueueConsumer(Jt400DataQueueEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        if (!this.endpoint.getSystem().isConnected()) {
            this.log.info((Object)("Connecting to " + (Object)((Object)this.endpoint)));
            this.endpoint.getSystem().connectService(3);
        }
    }

    protected void doStop() throws Exception {
        if (this.endpoint.getSystem().isConnected()) {
            this.log.info((Object)("Disconnecting from " + (Object)((Object)this.endpoint)));
            this.endpoint.getSystem().disconnectAllServices();
        }
    }

    public Exchange receive() {
        return this.receive(-1L);
    }

    public Exchange receiveNoWait() {
        return this.receive(0L);
    }

    public Exchange receive(long timeout) {
        DataQueue queue = this.endpoint.getDataQueue();
        try {
            DataQueueEntry entry;
            if (timeout >= 0L) {
                int seconds = (int)timeout / 1000;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Reading from data queue: " + queue.getName() + " with " + seconds + " seconds timeout"));
                }
                entry = queue.read(seconds);
            } else {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Reading from data queue: " + queue.getName() + " with no timeout"));
                }
                entry = queue.read(-1);
            }
            DefaultExchange exchange = new DefaultExchange(this.endpoint.getCamelContext());
            if (entry != null) {
                if (this.endpoint.getFormat() == Jt400DataQueueEndpoint.Format.binary) {
                    exchange.getIn().setBody((Object)entry.getData());
                } else {
                    exchange.getIn().setBody((Object)entry.getString());
                }
                return exchange;
            }
        }
        catch (AS400SecurityException e) {
            throw new RuntimeCamelException("Unable to read from data queue: " + queue.getName(), (Throwable)e);
        }
        catch (ErrorCompletingRequestException e) {
            throw new RuntimeCamelException("Unable to read from data queue: " + queue.getName(), (Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeCamelException("Unable to read from data queue: " + queue.getName(), (Throwable)e);
        }
        catch (IllegalObjectTypeException e) {
            throw new RuntimeCamelException("Unable to read from data queue: " + queue.getName(), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new RuntimeCamelException("Unable to read from data queue: " + queue.getName(), (Throwable)e);
        }
        catch (ObjectDoesNotExistException e) {
            throw new RuntimeCamelException("Unable to read from data queue: " + queue.getName(), (Throwable)e);
        }
        return null;
    }
}

