/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jt400;

import com.ibm.as400.access.DataQueue;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.jt400.Jt400DataQueueEndpoint;
import org.apache.camel.impl.DefaultProducer;

public class Jt400DataQueueProducer
extends DefaultProducer {
    private final Jt400DataQueueEndpoint endpoint;

    protected Jt400DataQueueProducer(Jt400DataQueueEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        DataQueue queue = this.endpoint.getDataQueue();
        if (this.endpoint.getFormat() == Jt400DataQueueEndpoint.Format.binary) {
            queue.write((byte[])exchange.getIn().getBody(byte[].class));
        } else {
            queue.write((String)exchange.getIn().getBody(String.class));
        }
    }

    protected void doStart() throws Exception {
        if (!this.endpoint.getSystem().isConnected()) {
            this.log.info((Object)("Connecting to " + (Object)((Object)this.endpoint)));
            this.endpoint.getSystem().connectService(3);
        }
    }

    protected void doStop() throws Exception {
        if (this.endpoint.getSystem().isConnected()) {
            this.log.info((Object)("Disconnecting from " + (Object)((Object)this.endpoint)));
            this.endpoint.getSystem().disconnectAllServices();
        }
    }
}

