/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jt400;

import com.ibm.as400.access.AS400;
import java.beans.PropertyVetoException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jt400.Jt400Component;
import org.apache.camel.component.jt400.Jt400PgmProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jt400PgmEndpoint
extends DefaultEndpoint {
    private static final transient Logger LOG = LoggerFactory.getLogger(Jt400PgmEndpoint.class);
    private String programToExecute;
    private Integer[] outputFieldsIdxArray;
    private Integer[] outputFieldsLengthArray;
    private AS400 iSeries;

    protected Jt400PgmEndpoint(String endpointUri, Jt400Component component) throws CamelException {
        super(endpointUri, (Component)component);
        try {
            URI uri = new URI(endpointUri);
            String[] credentials = uri.getUserInfo().split(":");
            this.iSeries = new AS400(uri.getHost(), credentials[0], credentials[1]);
            this.programToExecute = uri.getPath();
        }
        catch (URISyntaxException e) {
            throw new CamelException("Unable to parse URI for " + endpointUri, (Throwable)e);
        }
        try {
            this.iSeries.setGuiAvailable(false);
        }
        catch (PropertyVetoException e) {
            LOG.warn("Failed do disable AS/400 prompting in the environment running Camel.", (Throwable)e);
        }
    }

    public Jt400PgmEndpoint(String endpointUri, String programToExecute, Map<String, Object> parameters, CamelContext camelContext) {
        super(endpointUri, camelContext);
        this.programToExecute = programToExecute;
    }

    public Producer createProducer() throws Exception {
        return new Jt400PgmProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new OperationNotSupportedException();
    }

    public boolean isSingleton() {
        return false;
    }

    public void stop() throws Exception {
        super.stop();
        if (this.iSeries != null) {
            this.iSeries.disconnectAllServices();
        }
    }

    public boolean isFieldIdxForOuput(int idx) {
        return Arrays.binarySearch((Object[])this.outputFieldsIdxArray, (Object)idx) >= 0;
    }

    public int getOutputFieldLength(int idx) {
        return this.outputFieldsLengthArray[idx];
    }

    public String getProgramToExecute() {
        return this.programToExecute;
    }

    public AS400 getiSeries() {
        return this.iSeries;
    }

    public void setOutputFieldsIdx(String outputFieldsIdx) {
        if (outputFieldsIdx != null) {
            String[] outputArray = outputFieldsIdx.split(",");
            this.outputFieldsIdxArray = new Integer[outputArray.length];
            for (int i = 0; i < outputArray.length; ++i) {
                String str = outputArray[i];
                this.outputFieldsIdxArray[i] = Integer.parseInt(str);
            }
        }
    }

    public void setFieldsLength(String fieldsLength) {
        if (fieldsLength != null) {
            String[] outputArray = fieldsLength.split(",");
            this.outputFieldsLengthArray = new Integer[outputArray.length];
            for (int i = 0; i < outputArray.length; ++i) {
                String str = outputArray[i];
                this.outputFieldsLengthArray[i] = Integer.parseInt(str);
            }
        }
    }

    public void setGuiAvailable(boolean guiAvailable) throws PropertyVetoException {
        this.iSeries.setGuiAvailable(guiAvailable);
    }

    public boolean isGuiAvailable() {
        return this.iSeries != null && this.iSeries.isGuiAvailable();
    }
}

