/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.jxpath;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.impl.ExpressionSupport;
import org.apache.camel.language.ExpressionEvaluationException;
import org.apache.commons.jxpath.CompiledExpression;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXPathExpression
extends ExpressionSupport<Exchange> {
    private String expression;
    private CompiledExpression compiledExpression;
    private final Class<?> type;

    public JXPathExpression(String expression, Class<?> type) {
        this.expression = expression;
        this.type = type;
    }

    public Object evaluate(Exchange exchange) {
        try {
            JXPathContext context = JXPathContext.newContext((Object)exchange);
            Object result = this.getJXPathExpression().getValue(context, this.type);
            this.assertResultType(exchange, result);
            return result;
        }
        catch (JXPathException e) {
            throw new ExpressionEvaluationException((Expression)this, exchange, (Throwable)e);
        }
    }

    private void assertResultType(Exchange exchange, Object result) {
        if (result != null && !this.type.isAssignableFrom(result.getClass())) {
            throw new JXPathException("JXPath result type is " + result.getClass() + " instead of required type " + this.type);
        }
    }

    protected String assertionFailureMessage(Exchange exchange) {
        return this.expression.toString();
    }

    private synchronized CompiledExpression getJXPathExpression() {
        if (this.compiledExpression == null) {
            this.compiledExpression = JXPathContext.compile((String)this.expression);
        }
        return this.compiledExpression;
    }
}

