/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.util.Properties;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import kafka.producer.ProducerConfig;
import org.apache.camel.CamelException;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kafka.KafkaEndpoint;
import org.apache.camel.impl.DefaultProducer;

public class KafkaProducer
extends DefaultProducer {
    protected Producer<String, String> producer;
    private final KafkaEndpoint endpoint;

    public KafkaProducer(KafkaEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    protected void doStop() throws Exception {
        if (this.producer != null) {
            this.producer.close();
        }
    }

    Properties getProps() {
        Properties props = this.endpoint.getConfiguration().createProducerProperties();
        props.put("metadata.broker.list", this.endpoint.getBrokers());
        return props;
    }

    protected void doStart() throws Exception {
        Properties props = this.getProps();
        ProducerConfig config = new ProducerConfig(props);
        this.producer = new Producer(config);
    }

    public void process(Exchange exchange) throws CamelException {
        KeyedMessage data;
        String topic = (String)exchange.getIn().getHeader("kafka.TOPIC", (Object)this.endpoint.getTopic(), String.class);
        if (topic == null) {
            throw new CamelExchangeException("No topic key set", exchange);
        }
        String partitionKey = (String)exchange.getIn().getHeader("kafka.PARTITION_KEY", String.class);
        boolean hasPartitionKey = partitionKey != null;
        String messageKey = (String)exchange.getIn().getHeader("kafka.CONTENT_TYPE", String.class);
        boolean hasMessageKey = messageKey != null;
        String msg = (String)exchange.getIn().getBody(String.class);
        if (hasPartitionKey && hasMessageKey) {
            data = new KeyedMessage(topic, (Object)messageKey, (Object)partitionKey, (Object)msg);
        } else if (hasPartitionKey) {
            data = new KeyedMessage(topic, (Object)partitionKey, (Object)msg);
        } else if (hasMessageKey) {
            data = new KeyedMessage(topic, (Object)messageKey, (Object)msg);
        } else {
            this.log.warn("No message key or partition key set");
            data = new KeyedMessage(topic, (Object)messageKey, (Object)partitionKey, (Object)msg);
        }
        this.producer.send(data);
    }
}

