/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.net.URISyntaxException;
import java.util.concurrent.ExecutorService;
import kafka.message.MessageAndMetadata;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.kafka.KafkaComponent;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.KafkaConsumer;
import org.apache.camel.component.kafka.KafkaProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(scheme="kafka", title="Kafka", syntax="kafka:brokers", consumerClass=KafkaConsumer.class, label="messaging")
public class KafkaEndpoint
extends DefaultEndpoint
implements MultipleConsumersSupport {
    @UriPath
    @Metadata(required="true")
    private String brokers;
    @UriParam
    private KafkaConfiguration configuration = new KafkaConfiguration();

    public KafkaEndpoint() {
    }

    public KafkaEndpoint(String endpointUri, String remaining, KafkaComponent component) throws URISyntaxException {
        super(endpointUri, (Component)component);
        this.brokers = remaining.split("\\?")[0];
    }

    public KafkaConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = this.createConfiguration();
        }
        return this.configuration;
    }

    public void setConfiguration(KafkaConfiguration configuration) {
        this.configuration = configuration;
    }

    protected KafkaConfiguration createConfiguration() {
        return new KafkaConfiguration();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        KafkaConsumer consumer = new KafkaConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Producer createProducer() throws Exception {
        return new KafkaProducer(this);
    }

    public boolean isSingleton() {
        return true;
    }

    public ExecutorService createExecutor() {
        return this.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, "KafkaTopic[" + this.configuration.getTopic() + "]", this.configuration.getConsumerStreams());
    }

    public Exchange createKafkaExchange(MessageAndMetadata<byte[], byte[]> mm) {
        DefaultExchange exchange = new DefaultExchange(this.getCamelContext(), this.getExchangePattern());
        DefaultMessage message = new DefaultMessage();
        message.setHeader("kafka.EXCHANGE_NAME", (Object)mm.partition());
        message.setHeader("kafka.TOPIC", (Object)mm.topic());
        if (mm.key() != null) {
            message.setHeader("kafka.CONTENT_TYPE", (Object)new String((byte[])mm.key()));
        }
        message.setBody(mm.message());
        exchange.setIn((Message)message);
        return exchange;
    }

    public String getZookeeperConnect() {
        return this.configuration.getZookeeperConnect();
    }

    public void setZookeeperConnect(String zookeeperConnect) {
        this.configuration.setZookeeperConnect(zookeeperConnect);
    }

    public String getZookeeperHost() {
        return this.configuration.getZookeeperHost();
    }

    public void setZookeeperHost(String zookeeperHost) {
        this.configuration.setZookeeperHost(zookeeperHost);
    }

    public int getZookeeperPort() {
        return this.configuration.getZookeeperPort();
    }

    public void setZookeeperPort(int zookeeperPort) {
        this.configuration.setZookeeperPort(zookeeperPort);
    }

    public String getGroupId() {
        return this.configuration.getGroupId();
    }

    public void setGroupId(String groupId) {
        this.configuration.setGroupId(groupId);
    }

    public String getPartitioner() {
        return this.configuration.getPartitioner();
    }

    public void setPartitioner(String partitioner) {
        this.configuration.setPartitioner(partitioner);
    }

    public String getTopic() {
        return this.configuration.getTopic();
    }

    public void setTopic(String topic) {
        this.configuration.setTopic(topic);
    }

    public String getBrokers() {
        return this.brokers;
    }

    public int getConsumerStreams() {
        return this.configuration.getConsumerStreams();
    }

    public void setConsumerStreams(int consumerStreams) {
        this.configuration.setConsumerStreams(consumerStreams);
    }

    public int getBatchSize() {
        return this.configuration.getBatchSize();
    }

    public void setBatchSize(int batchSize) {
        this.configuration.setBatchSize(batchSize);
    }

    public int getBarrierAwaitTimeoutMs() {
        return this.configuration.getBarrierAwaitTimeoutMs();
    }

    public void setBarrierAwaitTimeoutMs(int barrierAwaitTimeoutMs) {
        this.configuration.setBarrierAwaitTimeoutMs(barrierAwaitTimeoutMs);
    }

    public int getConsumersCount() {
        return this.configuration.getConsumersCount();
    }

    public void setConsumersCount(int consumersCount) {
        this.configuration.setConsumersCount(consumersCount);
    }

    public void setConsumerTimeoutMs(int consumerTimeoutMs) {
        this.configuration.setConsumerTimeoutMs(consumerTimeoutMs);
    }

    public void setSerializerClass(String serializerClass) {
        this.configuration.setSerializerClass(serializerClass);
    }

    public void setQueueBufferingMaxMessages(int queueBufferingMaxMessages) {
        this.configuration.setQueueBufferingMaxMessages(queueBufferingMaxMessages);
    }

    public int getFetchWaitMaxMs() {
        return this.configuration.getFetchWaitMaxMs();
    }

    public Integer getZookeeperConnectionTimeoutMs() {
        return this.configuration.getZookeeperConnectionTimeoutMs();
    }

    public void setZookeeperConnectionTimeoutMs(Integer zookeeperConnectionTimeoutMs) {
        this.configuration.setZookeeperConnectionTimeoutMs(zookeeperConnectionTimeoutMs);
    }

    public void setMessageSendMaxRetries(int messageSendMaxRetries) {
        this.configuration.setMessageSendMaxRetries(messageSendMaxRetries);
    }

    public int getQueueBufferingMaxMs() {
        return this.configuration.getQueueBufferingMaxMs();
    }

    public void setRequestRequiredAcks(short requestRequiredAcks) {
        this.configuration.setRequestRequiredAcks(requestRequiredAcks);
    }

    public Integer getRebalanceBackoffMs() {
        return this.configuration.getRebalanceBackoffMs();
    }

    public void setQueueEnqueueTimeoutMs(int queueEnqueueTimeoutMs) {
        this.configuration.setQueueEnqueueTimeoutMs(queueEnqueueTimeoutMs);
    }

    public int getFetchMessageMaxBytes() {
        return this.configuration.getFetchMessageMaxBytes();
    }

    public int getQueuedMaxMessages() {
        return this.configuration.getQueuedMaxMessages();
    }

    public int getAutoCommitIntervalMs() {
        return this.configuration.getAutoCommitIntervalMs();
    }

    public void setSocketTimeoutMs(int socketTimeoutMs) {
        this.configuration.setSocketTimeoutMs(socketTimeoutMs);
    }

    public void setAutoCommitIntervalMs(int autoCommitIntervalMs) {
        this.configuration.setAutoCommitIntervalMs(autoCommitIntervalMs);
    }

    public void setRequestTimeoutMs(int requestTimeoutMs) {
        this.configuration.setRequestTimeoutMs(requestTimeoutMs);
    }

    public void setCompressedTopics(String compressedTopics) {
        this.configuration.setCompressedTopics(compressedTopics);
    }

    public int getSocketReceiveBufferBytes() {
        return this.configuration.getSocketReceiveBufferBytes();
    }

    public void setSendBufferBytes(int sendBufferBytes) {
        this.configuration.setSendBufferBytes(sendBufferBytes);
    }

    public void setFetchMessageMaxBytes(int fetchMessageMaxBytes) {
        this.configuration.setFetchMessageMaxBytes(fetchMessageMaxBytes);
    }

    public int getRefreshLeaderBackoffMs() {
        return this.configuration.getRefreshLeaderBackoffMs();
    }

    public void setFetchWaitMaxMs(int fetchWaitMaxMs) {
        this.configuration.setFetchWaitMaxMs(fetchWaitMaxMs);
    }

    public int getTopicMetadataRefreshIntervalMs() {
        return this.configuration.getTopicMetadataRefreshIntervalMs();
    }

    public void setZookeeperSessionTimeoutMs(int zookeeperSessionTimeoutMs) {
        this.configuration.setZookeeperSessionTimeoutMs(zookeeperSessionTimeoutMs);
    }

    public Integer getConsumerTimeoutMs() {
        return this.configuration.getConsumerTimeoutMs();
    }

    public void setAutoCommitEnable(boolean autoCommitEnable) {
        this.configuration.setAutoCommitEnable(autoCommitEnable);
    }

    public String getCompressionCodec() {
        return this.configuration.getCompressionCodec();
    }

    public void setProducerType(String producerType) {
        this.configuration.setProducerType(producerType);
    }

    public String getClientId() {
        return this.configuration.getClientId();
    }

    public int getFetchMinBytes() {
        return this.configuration.getFetchMinBytes();
    }

    public String getAutoOffsetReset() {
        return this.configuration.getAutoOffsetReset();
    }

    public void setRefreshLeaderBackoffMs(int refreshLeaderBackoffMs) {
        this.configuration.setRefreshLeaderBackoffMs(refreshLeaderBackoffMs);
    }

    public void setAutoOffsetReset(String autoOffsetReset) {
        this.configuration.setAutoOffsetReset(autoOffsetReset);
    }

    public void setConsumerId(String consumerId) {
        this.configuration.setConsumerId(consumerId);
    }

    public int getRetryBackoffMs() {
        return this.configuration.getRetryBackoffMs();
    }

    public int getRebalanceMaxRetries() {
        return this.configuration.getRebalanceMaxRetries();
    }

    public Boolean isAutoCommitEnable() {
        return this.configuration.isAutoCommitEnable();
    }

    public void setQueueBufferingMaxMs(int queueBufferingMaxMs) {
        this.configuration.setQueueBufferingMaxMs(queueBufferingMaxMs);
    }

    public void setRebalanceMaxRetries(int rebalanceMaxRetries) {
        this.configuration.setRebalanceMaxRetries(rebalanceMaxRetries);
    }

    public int getZookeeperSessionTimeoutMs() {
        return this.configuration.getZookeeperSessionTimeoutMs();
    }

    public void setKeySerializerClass(String keySerializerClass) {
        this.configuration.setKeySerializerClass(keySerializerClass);
    }

    public void setCompressionCodec(String compressionCodec) {
        this.configuration.setCompressionCodec(compressionCodec);
    }

    public void setClientId(String clientId) {
        this.configuration.setClientId(clientId);
    }

    public int getSocketTimeoutMs() {
        return this.configuration.getSocketTimeoutMs();
    }

    public String getCompressedTopics() {
        return this.configuration.getCompressedTopics();
    }

    public int getZookeeperSyncTimeMs() {
        return this.configuration.getZookeeperSyncTimeMs();
    }

    public void setSocketReceiveBufferBytes(int socketReceiveBufferBytes) {
        this.configuration.setSocketReceiveBufferBytes(socketReceiveBufferBytes);
    }

    public int getQueueEnqueueTimeoutMs() {
        return this.configuration.getQueueEnqueueTimeoutMs();
    }

    public int getQueueBufferingMaxMessages() {
        return this.configuration.getQueueBufferingMaxMessages();
    }

    public void setZookeeperSyncTimeMs(int zookeeperSyncTimeMs) {
        this.configuration.setZookeeperSyncTimeMs(zookeeperSyncTimeMs);
    }

    public String getKeySerializerClass() {
        return this.configuration.getKeySerializerClass();
    }

    public void setTopicMetadataRefreshIntervalMs(int topicMetadataRefreshIntervalMs) {
        this.configuration.setTopicMetadataRefreshIntervalMs(topicMetadataRefreshIntervalMs);
    }

    public void setBatchNumMessages(int batchNumMessages) {
        this.configuration.setBatchNumMessages(batchNumMessages);
    }

    public int getSendBufferBytes() {
        return this.configuration.getSendBufferBytes();
    }

    public void setRebalanceBackoffMs(Integer rebalanceBackoffMs) {
        this.configuration.setRebalanceBackoffMs(rebalanceBackoffMs);
    }

    public void setQueuedMaxMessages(int queuedMaxMessages) {
        this.configuration.setQueuedMaxMessages(queuedMaxMessages);
    }

    public void setRetryBackoffMs(int retryBackoffMs) {
        this.configuration.setRetryBackoffMs(retryBackoffMs);
    }

    public int getBatchNumMessages() {
        return this.configuration.getBatchNumMessages();
    }

    public short getRequestRequiredAcks() {
        return this.configuration.getRequestRequiredAcks();
    }

    public String getProducerType() {
        return this.configuration.getProducerType();
    }

    public String getConsumerId() {
        return this.configuration.getConsumerId();
    }

    public int getMessageSendMaxRetries() {
        return this.configuration.getMessageSendMaxRetries();
    }

    public void setFetchMinBytes(int fetchMinBytes) {
        this.configuration.setFetchMinBytes(fetchMinBytes);
    }

    public String getSerializerClass() {
        return this.configuration.getSerializerClass();
    }

    public int getRequestTimeoutMs() {
        return this.configuration.getRequestTimeoutMs();
    }

    public boolean isMultipleConsumersSupported() {
        return true;
    }
}

