/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.krati;

import java.util.LinkedList;
import java.util.Queue;
import krati.store.DataStore;
import krati.util.IndexedIterator;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.krati.KratiEndpoint;
import org.apache.camel.impl.ScheduledBatchPollingConsumer;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KratiConsumer
extends ScheduledBatchPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KratiConsumer.class);
    protected final KratiEndpoint endpoint;
    protected DataStore<Object, Object> dataStore;

    public KratiConsumer(KratiEndpoint endpoint, Processor processor, DataStore<Object, Object> dataStore) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.dataStore = dataStore;
    }

    protected int poll() throws Exception {
        int index;
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        int max = this.getMaxMessagesPerPoll() > 0 ? this.getMaxMessagesPerPoll() : Integer.MAX_VALUE;
        LinkedList<Exchange> queue = new LinkedList<Exchange>();
        IndexedIterator keyIterator = this.dataStore.keyIterator();
        for (index = 0; keyIterator.hasNext() && index < max; ++index) {
            Object key = keyIterator.next();
            Object value = this.dataStore.get(key);
            Exchange exchange = this.endpoint.createExchange();
            exchange.setProperty("CamelKratiKey", key);
            exchange.getIn().setBody(value);
            queue.add(exchange);
        }
        if (index == max && keyIterator.hasNext()) {
            this.log.debug("Limiting to maximum messages to poll {} as there was more messages in this poll.", (Object)max);
        }
        return queue.isEmpty() ? 0 : this.processBatch(CastUtils.cast(queue));
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty("CamelBatchIndex", (Object)index);
            exchange.setProperty("CamelBatchSize", (Object)total);
            exchange.setProperty("CamelBatchComplete", (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            exchange.addOnCompletion(new Synchronization(){

                public void onComplete(Exchange exchange) {
                    try {
                        KratiConsumer.this.dataStore.delete(exchange.getProperty("CamelKratiKey"));
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to remove from datastore. This exception is ignored.", (Throwable)e);
                    }
                }

                public void onFailure(Exchange exchange) {
                }
            });
            LOG.trace("Processing exchange [{}]...", (Object)exchange);
            this.getProcessor().process(exchange);
        }
        return total;
    }
}

