/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ldap;

import java.util.ArrayList;
import javax.naming.NamingEnumeration;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.ldap.LdapEndpoint;
import org.apache.camel.impl.DefaultProducer;

public class LdapProducer
extends DefaultProducer {
    private String remaining;
    private SearchControls controls;
    private String searchBase;

    public LdapProducer(LdapEndpoint endpoint, String remaining, String base, int scope) throws Exception {
        super((Endpoint)endpoint);
        this.remaining = remaining;
        this.searchBase = base;
        this.controls = new SearchControls();
        this.controls.setSearchScope(scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        String filter = (String)exchange.getIn().getBody(String.class);
        DirContext ldapContext = (DirContext)this.getEndpoint().getCamelContext().getRegistry().lookup(this.remaining);
        try {
            ArrayList<SearchResult> data = new ArrayList<SearchResult>();
            NamingEnumeration<SearchResult> namingEnumeration = ldapContext.search(this.searchBase, filter, this.getControls());
            while (namingEnumeration.hasMore()) {
                data.add(namingEnumeration.next());
            }
            exchange.getOut().setBody(data);
        }
        finally {
            ldapContext.close();
        }
    }

    protected SearchControls getControls() {
        return this.controls;
    }
}

