/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.mail.MailEndpoint;
import org.apache.camel.component.mail.MailExchange;
import org.apache.camel.component.mail.RuntimeMailException;
import org.apache.camel.converter.ObjectConverter;

public class MailBinding {
    public void populateMailMessage(MailEndpoint endpoint, MimeMessage mimeMessage, Exchange exchange) {
        try {
            this.appendHeadersFromCamel(mimeMessage, exchange, exchange.getIn());
            String destination = endpoint.getConfiguration().getDestination();
            if (destination != null) {
                mimeMessage.setRecipients(Message.RecipientType.TO, destination);
            }
            if (this.empty(mimeMessage.getFrom())) {
                String from = endpoint.getConfiguration().getFrom();
                mimeMessage.setFrom((Address)new InternetAddress(from));
            }
            if (exchange.getIn().getAttachments() != null && exchange.getIn().getAttachments().size() > 0) {
                this.appendAttachmentsFromCamel(mimeMessage, exchange, exchange.getIn());
            } else {
                mimeMessage.setText((String)exchange.getIn().getBody(String.class));
            }
        }
        catch (Exception e) {
            throw new RuntimeMailException("Failed to populate body due to: " + e + ". Exchange: " + exchange, e);
        }
    }

    protected boolean empty(Address[] addresses) {
        return addresses == null || addresses.length == 0;
    }

    public Object extractBodyFromMail(MailExchange exchange, javax.mail.Message message) {
        try {
            return message.getContent();
        }
        catch (Exception e) {
            throw new RuntimeMailException("Failed to extract body due to: " + e + ". Message: " + message, e);
        }
    }

    protected void appendHeadersFromCamel(MimeMessage mimeMessage, Exchange exchange, Message camelMessage) throws MessagingException {
        Set entries = camelMessage.getHeaders().entrySet();
        for (Map.Entry entry : entries) {
            String headerName = (String)entry.getKey();
            Object headerValue = entry.getValue();
            if (headerValue == null || !this.shouldOutputHeader(camelMessage, headerName, headerValue)) continue;
            if (ObjectConverter.isCollection(headerValue)) {
                Iterator iter = ObjectConverter.iterator(headerValue);
                while (iter.hasNext()) {
                    Object value = iter.next();
                    mimeMessage.addHeader(headerName, this.asString(exchange, value));
                }
                continue;
            }
            mimeMessage.setHeader(headerName, this.asString(exchange, headerValue));
        }
    }

    protected void appendAttachmentsFromCamel(MimeMessage mimeMessage, Exchange exchange, Message camelMessage) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        multipart.setSubType("mixed");
        MimeBodyPart textBodyPart = new MimeBodyPart();
        textBodyPart.setContent(exchange.getIn().getBody(String.class), "text/plain");
        multipart.addBodyPart((BodyPart)textBodyPart);
        MimeBodyPart messageBodyPart = null;
        Set entries = camelMessage.getAttachments().entrySet();
        for (Map.Entry entry : entries) {
            String attName = (String)entry.getKey();
            DataHandler attValue = (DataHandler)entry.getValue();
            if (attValue == null || !this.shouldOutputAttachment(camelMessage, attName, attValue)) continue;
            messageBodyPart = new MimeBodyPart();
            messageBodyPart.setDataHandler(attValue);
            messageBodyPart.setFileName(attName);
            messageBodyPart.setDisposition("attachment");
            multipart.addBodyPart((BodyPart)messageBodyPart);
        }
        mimeMessage.setContent((Multipart)multipart);
    }

    protected String asString(Exchange exchange, Object value) {
        return (String)exchange.getContext().getTypeConverter().convertTo(String.class, value);
    }

    protected boolean shouldOutputHeader(Message camelMessage, String headerName, Object headerValue) {
        return true;
    }

    protected boolean shouldOutputAttachment(Message camelMessage, String headerName, DataHandler headerValue) {
        return true;
    }
}

