/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.io.IOException;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMultipart;
import org.apache.camel.Converter;

@Converter
public class MailConverters {
    @Converter
    public String toString(Message message) throws MessagingException, IOException {
        MimeMultipart multipart;
        Object content = message.getContent();
        if (content instanceof MimeMultipart && (multipart = (MimeMultipart)content).getCount() > 0) {
            BodyPart part = multipart.getBodyPart(0);
            content = part.getContent();
        }
        if (content != null) {
            return content.toString();
        }
        return null;
    }

    @Converter
    public static String toString(Multipart multipart) throws MessagingException, IOException {
        int size = multipart.getCount();
        for (int i = 0; i < size; ++i) {
            BodyPart part = multipart.getBodyPart(i);
            if (!part.getContentType().startsWith("text")) continue;
            return part.getContent().toString();
        }
        return null;
    }
}

