/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.mail.MailConfiguration;
import org.apache.camel.component.mail.MailEndpoint;
import org.apache.camel.component.mail.MailExchange;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.impl.DefaultHeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.CollectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailBinding {
    private HeaderFilterStrategy headerFilterStrategy;

    public MailBinding() {
        this.headerFilterStrategy = new DefaultHeaderFilterStrategy();
    }

    public MailBinding(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public void populateMailMessage(MailEndpoint endpoint, MimeMessage mimeMessage, Exchange exchange) throws MessagingException, IOException {
        if (MailBinding.hasRecipientHeaders(exchange.getIn())) {
            this.setRecipientFromCamelMessage(mimeMessage, exchange, exchange.getIn());
        } else {
            this.setRecipientFromEndpointConfiguration(mimeMessage, endpoint);
        }
        if (mimeMessage.getAllRecipients() == null) {
            throw new IllegalArgumentException("The mail message does not have any recipients set.");
        }
        this.appendHeadersFromCamelMessage(mimeMessage, exchange, exchange.getIn());
        if (MailBinding.empty(mimeMessage.getFrom())) {
            String from = endpoint.getConfiguration().getFrom();
            mimeMessage.setFrom((Address)new InternetAddress(from));
        }
        if (exchange.getIn().hasAttachments()) {
            this.appendAttachmentsFromCamel(mimeMessage, exchange.getIn(), endpoint.getConfiguration());
        } else if ("text/html".equals(endpoint.getConfiguration().getContentType())) {
            ByteArrayDataSource ds = new ByteArrayDataSource((String)exchange.getIn().getBody(String.class), "text/html");
            mimeMessage.setDataHandler(new DataHandler((DataSource)ds));
        } else {
            mimeMessage.setText((String)exchange.getIn().getBody(String.class));
        }
    }

    public Object extractBodyFromMail(MailExchange exchange, javax.mail.Message message) {
        try {
            return message.getContent();
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Failed to extract body due to: " + e.getMessage() + ". Exchange: " + (Object)((Object)exchange) + ". Message: " + message, (Throwable)e);
        }
    }

    protected void appendHeadersFromCamelMessage(MimeMessage mimeMessage, Exchange exchange, Message camelMessage) throws MessagingException {
        for (Map.Entry entry : camelMessage.getHeaders().entrySet()) {
            String headerName = (String)entry.getKey();
            Object headerValue = entry.getValue();
            if (headerValue == null || this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(headerName, headerValue) || MailBinding.isRecipientHeader(headerName)) continue;
            if (ObjectConverter.isCollection(headerValue)) {
                Iterator iter = ObjectConverter.iterator(headerValue);
                while (iter.hasNext()) {
                    Object value = iter.next();
                    mimeMessage.addHeader(headerName, MailBinding.asString(exchange, value));
                }
                continue;
            }
            mimeMessage.setHeader(headerName, MailBinding.asString(exchange, headerValue));
        }
    }

    private void setRecipientFromCamelMessage(MimeMessage mimeMessage, Exchange exchange, Message camelMessage) throws MessagingException {
        for (Map.Entry entry : camelMessage.getHeaders().entrySet()) {
            String headerName = (String)entry.getKey();
            Object headerValue = entry.getValue();
            if (headerValue == null || !MailBinding.isRecipientHeader(headerName)) continue;
            if (ObjectConverter.isCollection(headerValue)) {
                Iterator iter = ObjectConverter.iterator(headerValue);
                while (iter.hasNext()) {
                    Object recipient = iter.next();
                    MailBinding.appendRecipientToMimeMessage(mimeMessage, headerName, MailBinding.asString(exchange, recipient));
                }
                continue;
            }
            MailBinding.appendRecipientToMimeMessage(mimeMessage, headerName, MailBinding.asString(exchange, headerValue));
        }
    }

    protected void setRecipientFromEndpointConfiguration(MimeMessage mimeMessage, MailEndpoint endpoint) throws MessagingException {
        String destination;
        Map<Message.RecipientType, String> recipients = endpoint.getConfiguration().getRecipients();
        if (recipients.containsKey(Message.RecipientType.TO)) {
            MailBinding.appendRecipientToMimeMessage(mimeMessage, Message.RecipientType.TO.toString(), recipients.get(Message.RecipientType.TO));
        }
        if (recipients.containsKey(Message.RecipientType.CC)) {
            MailBinding.appendRecipientToMimeMessage(mimeMessage, Message.RecipientType.CC.toString(), recipients.get(Message.RecipientType.CC));
        }
        if (recipients.containsKey(Message.RecipientType.BCC)) {
            MailBinding.appendRecipientToMimeMessage(mimeMessage, Message.RecipientType.BCC.toString(), recipients.get(Message.RecipientType.BCC));
        }
        if ((destination = endpoint.getConfiguration().getDestination()) != null && mimeMessage.getRecipients(Message.RecipientType.TO) == null) {
            MailBinding.appendRecipientToMimeMessage(mimeMessage, Message.RecipientType.TO.toString(), destination);
        }
    }

    protected void appendAttachmentsFromCamel(MimeMessage mimeMessage, Message camelMessage, MailConfiguration configuration) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        multipart.setSubType("mixed");
        MimeBodyPart textBodyPart = new MimeBodyPart();
        textBodyPart.setContent(camelMessage.getBody(String.class), configuration.getContentType());
        multipart.addBodyPart((BodyPart)textBodyPart);
        for (Map.Entry entry : camelMessage.getAttachments().entrySet()) {
            String attachmentFilename = (String)entry.getKey();
            DataHandler handler = (DataHandler)entry.getValue();
            if (handler == null || !this.shouldOutputAttachment(camelMessage, attachmentFilename, handler)) continue;
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setDataHandler(handler);
            messageBodyPart.setFileName(attachmentFilename);
            messageBodyPart.setDisposition("attachment");
            multipart.addBodyPart((BodyPart)messageBodyPart);
        }
        mimeMessage.setContent((Multipart)multipart);
    }

    protected boolean shouldOutputAttachment(Message camelMessage, String attachmentFilename, DataHandler handler) {
        return true;
    }

    protected Map<String, Object> extractHeadersFromMail(javax.mail.Message mailMessage) throws MessagingException {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        Enumeration names = mailMessage.getAllHeaders();
        while (names.hasMoreElements()) {
            Header header = (Header)names.nextElement();
            String[] value = mailMessage.getHeader(header.getName());
            if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(header.getName(), (Object)value)) continue;
            if (value.length == 1) {
                CollectionHelper.appendValue(answer, (Object)header.getName().toLowerCase(), (Object)value[0]);
                continue;
            }
            CollectionHelper.appendValue(answer, (Object)header.getName().toLowerCase(), (Object)value);
        }
        return answer;
    }

    private static void appendRecipientToMimeMessage(MimeMessage mimeMessage, String type, String recipient) throws MessagingException {
        String[] lines;
        for (String line : lines = recipient.split("[,|;]")) {
            line = line.trim();
            mimeMessage.addRecipients(MailBinding.asRecipientType(type), line);
        }
    }

    private static boolean hasRecipientHeaders(Message camelMessage) {
        for (String key : camelMessage.getHeaders().keySet()) {
            if (!MailBinding.isRecipientHeader(key)) continue;
            return true;
        }
        return false;
    }

    private static boolean isRecipientHeader(String key) {
        if (Message.RecipientType.TO.toString().equalsIgnoreCase(key)) {
            return true;
        }
        if (Message.RecipientType.CC.toString().equalsIgnoreCase(key)) {
            return true;
        }
        return Message.RecipientType.BCC.toString().equalsIgnoreCase(key);
    }

    private static Message.RecipientType asRecipientType(String type) {
        if (Message.RecipientType.TO.toString().equalsIgnoreCase(type)) {
            return Message.RecipientType.TO;
        }
        if (Message.RecipientType.CC.toString().equalsIgnoreCase(type)) {
            return Message.RecipientType.CC;
        }
        if (Message.RecipientType.BCC.toString().equalsIgnoreCase(type)) {
            return Message.RecipientType.BCC;
        }
        throw new IllegalArgumentException("Unknown recipient type: " + type);
    }

    private static boolean empty(Address[] addresses) {
        return addresses == null || addresses.length == 0;
    }

    private static String asString(Exchange exchange, Object value) {
        return (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, value);
    }
}

