/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.io.IOException;
import java.io.InputStream;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMultipart;
import org.apache.camel.Converter;
import org.apache.camel.converter.IOConverter;

@Converter
public final class MailConverters {
    private MailConverters() {
    }

    @Converter
    public static String toString(Message message) throws MessagingException, IOException {
        MimeMultipart multipart;
        Object content = message.getContent();
        if (content instanceof MimeMultipart && (multipart = (MimeMultipart)content).getCount() > 0) {
            BodyPart part = multipart.getBodyPart(0);
            content = part.getContent();
        }
        if (content != null) {
            return content.toString();
        }
        return null;
    }

    @Converter
    public static String toString(Multipart multipart) throws MessagingException, IOException {
        int size = multipart.getCount();
        for (int i = 0; i < size; ++i) {
            BodyPart part = multipart.getBodyPart(i);
            if (!part.getContentType().toLowerCase().startsWith("text")) continue;
            return part.getContent().toString();
        }
        return null;
    }

    @Converter
    public static InputStream toInputStream(Message message) throws IOException, MessagingException {
        return message.getInputStream();
    }

    @Converter
    public static InputStream toInputStream(Multipart multipart) throws IOException, MessagingException {
        String s = MailConverters.toString(multipart);
        if (s == null) {
            return null;
        }
        return IOConverter.toInputStream((String)s, null);
    }
}

