/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.util.LinkedList;
import java.util.Queue;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import org.apache.camel.BatchConsumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.component.mail.MailConfiguration;
import org.apache.camel.component.mail.MailEndpoint;
import org.apache.camel.component.mail.MailMessage;
import org.apache.camel.component.mail.MailUtils;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.mail.javamail.JavaMailSenderImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailConsumer
extends ScheduledPollConsumer
implements BatchConsumer,
ShutdownAware {
    public static final long DEFAULT_CONSUMER_DELAY = 60000L;
    private static final transient Log LOG = LogFactory.getLog(MailConsumer.class);
    private final JavaMailSenderImpl sender;
    private Folder folder;
    private Store store;
    private int maxMessagesPerPoll;
    private volatile ShutdownRunningTask shutdownRunningTask;
    private volatile int pendingExchanges;

    public MailConsumer(MailEndpoint endpoint, Processor processor, JavaMailSenderImpl sender) {
        super((DefaultEndpoint)endpoint, processor);
        this.sender = sender;
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.folder != null && this.folder.isOpen()) {
            this.folder.close(true);
        }
        if (this.store != null && this.store.isConnected()) {
            this.store.close();
        }
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int poll() throws Exception {
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        int polledMessages = 0;
        this.ensureIsConnected();
        if (this.store == null || this.folder == null) {
            throw new IllegalStateException("MailConsumer did not connect properly to the MailStore: " + this.getEndpoint().getConfiguration().getMailStoreLogInformation());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Polling mailfolder: " + this.getEndpoint().getConfiguration().getMailStoreLogInformation()));
        }
        if (this.getEndpoint().getConfiguration().getFetchSize() == 0) {
            LOG.warn((Object)"Fetch size is 0 meaning the configuration is set to poll no new messages at all. Camel will skip this poll.");
            return 0;
        }
        if (!this.folder.isOpen()) {
            this.folder.open(2);
        }
        try {
            int count = this.folder.getMessageCount();
            if (count > 0) {
                Message[] messages = this.getEndpoint().getConfiguration().isUnseen() ? this.folder.search((SearchTerm)new FlagTerm(new Flags(Flags.Flag.SEEN), false)) : this.folder.getMessages();
                polledMessages = this.processBatch(CastUtils.cast(this.createExchanges(messages)));
            } else if (count == -1) {
                throw new MessagingException("Folder: " + this.folder.getFullName() + " is closed");
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            try {
                if (this.folder.isOpen()) {
                    this.folder.close(true);
                }
            }
            catch (Exception e) {
                LOG.debug((Object)("Could not close mailbox folder: " + this.folder.getName()), (Throwable)e);
            }
        }
        return polledMessages;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        if (this.maxMessagesPerPoll > 0 && total > this.maxMessagesPerPoll) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Limiting to maximum messages to poll " + this.maxMessagesPerPoll + " as there was " + total + " messages in this poll."));
            }
            total = this.maxMessagesPerPoll;
        }
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty("CamelBatchIndex", (Object)index);
            exchange.setProperty("CamelBatchSize", (Object)total);
            exchange.setProperty("CamelBatchComplete", (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            final Message mail = ((MailMessage)((Object)exchange.getIn(MailMessage.class))).getOriginalMessage();
            exchange.addOnCompletion(new Synchronization(){

                public void onComplete(Exchange exchange) {
                    MailConsumer.this.processCommit(mail, exchange);
                }

                public void onFailure(Exchange exchange) {
                    MailConsumer.this.processRollback(mail, exchange);
                }

                public String toString() {
                    return "MailConsumerOnCompletion";
                }
            });
            this.processExchange(exchange);
        }
        return total;
    }

    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
        return false;
    }

    public int getPendingExchangesSize() {
        if (ShutdownRunningTask.CompleteAllTasks == this.shutdownRunningTask) {
            return this.pendingExchanges;
        }
        return 0;
    }

    public void prepareShutdown() {
    }

    public boolean isBatchAllowed() {
        boolean answer = this.isRunAllowed();
        if (!answer) {
            return false;
        }
        if (this.shutdownRunningTask == null) {
            return true;
        }
        return ShutdownRunningTask.CompleteAllTasks == this.shutdownRunningTask;
    }

    protected Queue<Exchange> createExchanges(Message[] messages) throws MessagingException {
        int count;
        LinkedList<Exchange> answer = new LinkedList<Exchange>();
        int fetchSize = this.getEndpoint().getConfiguration().getFetchSize();
        int n = count = fetchSize == -1 ? messages.length : Math.min(fetchSize, messages.length);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Fetching " + count + " messages. Total " + messages.length + " messages."));
        }
        for (int i = 0; i < count; ++i) {
            Message message = messages[i];
            if (!message.getFlags().contains(Flags.Flag.DELETED)) {
                Exchange exchange = this.getEndpoint().createExchange(message);
                answer.add(exchange);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Skipping message as it was flagged as deleted: " + MailUtils.dumpMessage(message)));
        }
        return answer;
    }

    protected void processExchange(Exchange exchange) throws Exception {
        if (LOG.isDebugEnabled()) {
            MailMessage msg = (MailMessage)exchange.getIn();
            LOG.debug((Object)("Processing message: " + MailUtils.dumpMessage(msg.getMessage())));
        }
        this.getProcessor().process(exchange);
    }

    protected void processCommit(Message mail, Exchange exchange) {
        try {
            if (this.getEndpoint().getConfiguration().isDelete()) {
                LOG.debug((Object)"Exchange processed, so flagging message as DELETED");
                mail.setFlag(Flags.Flag.DELETED, true);
            } else {
                LOG.debug((Object)"Exchange processed, so flagging message as SEEN");
                mail.setFlag(Flags.Flag.SEEN, true);
            }
        }
        catch (MessagingException e) {
            LOG.warn((Object)"Error occurred during flagging message as DELETED/SEEN", (Throwable)e);
            exchange.setException((Throwable)e);
        }
    }

    protected void processRollback(Message mail, Exchange exchange) {
        Exception cause = exchange.getException();
        if (cause != null) {
            LOG.warn((Object)("Exchange failed, so rolling back message status: " + exchange), (Throwable)cause);
        } else {
            LOG.warn((Object)("Exchange failed, so rolling back message status: " + exchange));
        }
    }

    private void ensureIsConnected() throws MessagingException {
        MailConfiguration config = this.getEndpoint().getConfiguration();
        boolean connected = false;
        try {
            if (this.store != null && this.store.isConnected()) {
                connected = true;
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("Exception while testing for is connected to MailStore: " + this.getEndpoint().getConfiguration().getMailStoreLogInformation() + ". Caused by: " + e.getMessage()), (Throwable)e);
        }
        if (!connected) {
            this.store = null;
            this.folder = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Connecting to MailStore: " + this.getEndpoint().getConfiguration().getMailStoreLogInformation()));
            }
            this.store = this.sender.getSession().getStore(config.getProtocol());
            this.store.connect(config.getHost(), config.getPort(), config.getUsername(), config.getPassword());
        }
        if (this.folder == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Getting folder " + config.getFolderName()));
            }
            this.folder = this.store.getFolder(config.getFolderName());
            if (this.folder == null || !this.folder.exists()) {
                throw new FolderNotFoundException(this.folder, "Folder not found or invalid: " + config.getFolderName());
            }
        }
    }

    public MailEndpoint getEndpoint() {
        return (MailEndpoint)super.getEndpoint();
    }
}

