/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.mail.ContentTypeResolver;
import org.apache.camel.component.mail.MailConfiguration;
import org.apache.camel.component.mail.MailEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

public class MailComponent
extends DefaultComponent {
    private MailConfiguration configuration;
    private ContentTypeResolver contentTypeResolver;

    public MailComponent() {
        this.configuration = new MailConfiguration();
    }

    public MailComponent(MailConfiguration configuration) {
        this.configuration = configuration;
    }

    public MailComponent(CamelContext context) {
        super(context);
        this.configuration = new MailConfiguration();
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        URI url = new URI(uri);
        if ("nntp".equalsIgnoreCase(url.getScheme())) {
            throw new UnsupportedOperationException("nntp protocol is not supported");
        }
        ObjectHelper.notNull((Object)this.configuration, (String)"configuration");
        MailConfiguration config = this.configuration.copy();
        config.configure(url);
        this.configureAdditionalJavaMailProperties(config, parameters);
        MailEndpoint endpoint = new MailEndpoint(uri, this, config);
        endpoint.setContentTypeResolver(this.contentTypeResolver);
        this.setProperties(endpoint.getConfiguration(), parameters);
        ObjectHelper.notEmpty((String)config.getHost(), (String)"host");
        ObjectHelper.notEmpty((String)config.getProtocol(), (String)"protocol");
        return endpoint;
    }

    private void configureAdditionalJavaMailProperties(MailConfiguration config, Map parameters) {
        HashSet toRemove = new HashSet();
        for (Map.Entry object : parameters.entrySet()) {
            Map.Entry entry = object;
            if (!entry.getKey().toString().startsWith("mail.")) continue;
            config.getAdditionalJavaMailProperties().put(entry.getKey(), entry.getValue());
            toRemove.add(entry.getKey());
        }
        for (Map.Entry key : toRemove) {
            parameters.remove(key);
        }
    }

    public MailConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MailConfiguration configuration) {
        this.configuration = configuration;
    }

    public ContentTypeResolver getContentTypeResolver() {
        return this.contentTypeResolver;
    }

    public void setContentTypeResolver(ContentTypeResolver contentTypeResolver) {
        this.contentTypeResolver = contentTypeResolver;
    }
}

