/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import javax.mail.Message;
import javax.mail.internet.MimeMessage;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.mail.MailEndpoint;
import org.apache.camel.component.mail.MailUtils;
import org.apache.camel.impl.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessagePreparator;

public class MailProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(MailProducer.class);
    private final JavaMailSender sender;

    public MailProducer(MailEndpoint endpoint, JavaMailSender sender) {
        super((Endpoint)endpoint);
        this.sender = sender;
    }

    public void process(final Exchange exchange) {
        this.sender.send(new MimeMessagePreparator(){

            public void prepare(MimeMessage mimeMessage) throws Exception {
                MailProducer.this.getEndpoint().getBinding().populateMailMessage(MailProducer.this.getEndpoint(), mimeMessage, exchange);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sending MimeMessage: {}", (Object)MailUtils.dumpMessage((Message)mimeMessage));
                }
            }
        });
    }

    public MailEndpoint getEndpoint() {
        return (MailEndpoint)super.getEndpoint();
    }
}

