/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.manual;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.ccil.cowan.tagsoup.HTMLSchema;
import org.ccil.cowan.tagsoup.Parser;
import org.ccil.cowan.tagsoup.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ManualGenerator {
    String page;
    String output;
    String head;
    String version;
    String targetDir;
    String skip;

    public ManualGenerator(String[] args) {
        this.page = args[0];
        this.output = args[1];
        this.version = args[2];
        this.head = args[3];
        this.targetDir = args[4];
        this.skip = args[5];
    }

    public void run() {
        try {
            if (this.doGenerate()) {
                String content = this.grabBodyContent();
                this.storeHTMLFile(content);
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void storeHTMLFile(String content) throws IOException {
        String replaceToken = "<h3 id=\"replaceme\">.*</h3>";
        String replaceValue = "<h3>Version " + this.version + "</h3>";
        File outFile = new File(this.output);
        outFile.getParentFile().mkdirs();
        PrintWriter out = new PrintWriter(new BufferedOutputStream(new FileOutputStream(outFile)));
        out.println("<html>");
        out.println("<head>");
        if (this.head != null) {
            out.println(this.head);
        }
        out.println("</head>");
        if (replaceToken != null && replaceValue != null) {
            content = content.replaceAll(replaceToken, replaceValue);
        }
        out.print("<body>");
        out.print(content);
        out.println("</body>");
        out.close();
    }

    private boolean doGenerate() throws MalformedURLException, IOException {
        if (this.skip.equalsIgnoreCase("true")) {
            return false;
        }
        URL url = new URL(this.page);
        File file = new File(this.targetDir, ".manualCache-" + url.getFile().substring(1));
        if (file.exists()) {
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("HEAD");
            long date = con.getLastModified();
            FileReader reader = new FileReader(file);
            char[] chars = new char[1000];
            int i = reader.read(chars);
            reader.close();
            long lastDate = Long.parseLong(new String(chars, 0, i).trim());
            if (date <= lastDate) {
                return false;
            }
        }
        return true;
    }

    private String grabBodyContent() throws MalformedURLException, IOException {
        URL url = new URL(this.page);
        File file = new File(this.targetDir, ".manualCache-" + url.getFile().substring(1));
        try {
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            Parser parser = new Parser();
            parser.setFeature("http://xml.org/sax/features/namespaces", false);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            parser.setProperty("http://www.ccil.org/~cowan/tagsoup/properties/schema", new HTMLSchema(){
                {
                    this.elementType("ul", 16384, 16388, 0);
                }
            });
            StringWriter w = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(w){
                int inDiv;
                int count;
                {
                    this.inDiv = Integer.MAX_VALUE;
                }

                public void characters(char[] ch, int start, int len) throws SAXException {
                    if (this.inDiv <= this.count) {
                        super.characters(ch, start, len);
                    }
                }

                public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                    ++this.count;
                    if ("div".equalsIgnoreCase(qName) && "wiki-content maincontent".equalsIgnoreCase(atts.getValue("class"))) {
                        this.inDiv = this.count;
                    }
                    if (this.inDiv <= this.count) {
                        super.startElement(uri, localName, qName, atts);
                    }
                }

                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (this.inDiv <= this.count) {
                        super.endElement(uri, localName, qName);
                    }
                    --this.count;
                    if (this.inDiv > this.count) {
                        this.inDiv = Integer.MAX_VALUE;
                    }
                }
            };
            xmlWriter.setOutputProperty("omit-xml-declaration", "yes");
            xmlWriter.setOutputProperty("method", "html");
            parser.setContentHandler((ContentHandler)xmlWriter);
            long date = con.getLastModified();
            parser.parse(new InputSource(new BufferedInputStream(con.getInputStream())));
            FileWriter writer = new FileWriter(file);
            writer.write(Long.toString(date));
            writer.close();
            return w.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException("Failed", e);
        }
    }

    public static void main(String[] args) {
        new ManualGenerator(args).run();
    }
}

