/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.camel.impl.DefaultPackageScanClassResolver;
import org.apache.camel.maven.EmbeddedMojo;
import org.apache.camel.maven.ReportingTypeConverterLoader;
import org.apache.camel.maven.ReportingTypeConverterRegistry;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.util.ObjectHelper;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.module.xhtml.decoration.render.RenderingContext;
import org.apache.maven.doxia.site.decoration.Body;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.Skin;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertersMojo
extends AbstractMavenReport {
    private static final String WIKI_TYPECONVERER_URL = "http://camel.apache.org/type-converter.html";
    private static final String CONVERTER_TYPE_STATIC = "org.apache.camel.impl.converter.StaticMethodTypeConverter";
    private static final String CONVERTER_TYPE_INSTANCE = "org.apache.camel.impl.converter.InstanceMethodTypeConverter";
    private static final String REPORT_METHOD_STATIC = "STATIC";
    private static final String REPORT_METHOD_INSTANCE = "INSTANCE";
    private static final String REPORT_METHOD_UNKNOWN = "UNKNOWN";
    protected List remoteArtifactRepositories;
    protected ArtifactRepository localRepository;
    protected ArtifactResolver artifactResolver;
    protected ArtifactFactory artifactFactory;
    private File outputDirectory;
    private MavenProject project;
    private Renderer renderer;

    protected ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("camel-maven-plugin", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.converters.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.converters.name");
    }

    public String getOutputName() {
        return "camel-converters";
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.renderer;
    }

    public void execute() throws MojoExecutionException {
        if (!this.canGenerateReport()) {
            return;
        }
        try {
            DecorationModel model = new DecorationModel();
            model.setBody(new Body());
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("outputEncoding", "UTF-8");
            attributes.put("project", (String)this.project);
            Locale locale = Locale.getDefault();
            SiteRenderingContext siteContext = this.renderer.createContextForSkin(this.getSkinArtifactFile(model), attributes, model, this.getName(locale), locale);
            RenderingContext context = new RenderingContext(this.getReportOutputDirectory(), this.getOutputName() + ".html");
            SiteRendererSink sink = new SiteRendererSink(context);
            this.generate((Sink)sink, locale);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.getReportOutputDirectory(), this.getOutputName() + ".html")), "UTF-8");
            this.renderer.generateDocument((Writer)writer, sink, siteContext);
            this.renderer.copyResources(siteContext, new File(this.project.getBasedir(), "src/site/resources"), this.outputDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying resources.", (Exception)e);
        }
        catch (RendererException e) {
            throw new MojoExecutionException("Error while rendering report.", (Exception)((Object)e));
        }
        catch (MojoFailureException e) {
            throw new MojoExecutionException("Cannot find skin artifact for report.", (Exception)((Object)e));
        }
        catch (MavenReportException e) {
            throw new MojoExecutionException("Error generating report.", (Exception)((Object)e));
        }
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        if (!this.createOutputDirectory(this.outputDirectory)) {
            throw new MavenReportException("Failed to create report directory " + this.outputDirectory.getAbsolutePath());
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            String[] errors;
            List list = this.project.getTestClasspathElements();
            EmbeddedMojo mojo = new EmbeddedMojo();
            mojo.setClasspathElements(list);
            ClassLoader newClassLoader = mojo.createClassLoader(oldClassLoader);
            Thread.currentThread().setContextClassLoader(newClassLoader);
            ReportingTypeConverterLoader loader = new ReportingTypeConverterLoader((PackageScanClassResolver)new DefaultPackageScanClassResolver());
            ReportingTypeConverterRegistry registry = new ReportingTypeConverterRegistry();
            loader.load(registry);
            this.getLog().error((CharSequence)("FOUND type mapping; count = " + loader.getTypeConversions().length));
            for (String error : errors = registry.getErrors()) {
                this.getLog().error((CharSequence)error);
            }
            this.generateReport(this.getSink(), locale, loader.getTypeConversions());
        }
        catch (Exception e) {
            throw new MavenReportException("Failed to generate TypeConverters report", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private boolean createOutputDirectory(File outputDir) {
        if (outputDir.exists()) {
            if (!outputDir.isDirectory()) {
                this.getLog().error((CharSequence)("File with same name already exists: " + outputDir.getAbsolutePath()));
                return false;
            }
        } else if (!outputDir.mkdirs()) {
            this.getLog().error((CharSequence)("Cannot make output directory at: " + outputDir.getAbsolutePath()));
            return false;
        }
        return true;
    }

    private File getSkinArtifactFile(DecorationModel decoration) throws MojoFailureException {
        Skin skin = decoration.getSkin();
        if (skin == null) {
            skin = Skin.getDefaultSkin();
        }
        String version = skin.getVersion();
        try {
            if (version == null) {
                version = "RELEASE";
            }
            VersionRange versionSpec = VersionRange.createFromVersionSpec((String)version);
            Artifact artifact = this.artifactFactory.createDependencyArtifact(skin.getGroupId(), skin.getArtifactId(), versionSpec, "jar", null, null);
            this.artifactResolver.resolve(artifact, this.remoteArtifactRepositories, this.localRepository);
            return artifact.getFile();
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoFailureException("The skin version '" + version + "' is not valid: " + e.getMessage());
        }
        catch (ArtifactResolutionException e) {
            throw new MojoFailureException("Unable to fink skin: " + e.getMessage());
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoFailureException("The skin does not exist: " + e.getMessage());
        }
    }

    private String converterType(String converterClassName) {
        if (CONVERTER_TYPE_STATIC.equals(converterClassName)) {
            return REPORT_METHOD_STATIC;
        }
        if (CONVERTER_TYPE_INSTANCE.equals(converterClassName)) {
            return REPORT_METHOD_INSTANCE;
        }
        return REPORT_METHOD_UNKNOWN;
    }

    private void generateReport(org.apache.maven.doxia.sink.Sink sink, Locale locale, ReportingTypeConverterLoader.TypeMapping[] mappings) throws MojoExecutionException {
        this.beginReport(sink, locale);
        TreeMap<String, Set<String>> packages = new TreeMap<String, Set<String>>();
        Class prevFrom = null;
        Class prevTo = null;
        sink.table();
        this.tableHeader(sink, locale);
        for (ReportingTypeConverterLoader.TypeMapping mapping : mappings) {
            Set<String> classes;
            boolean ignored = false;
            Class from = mapping.getFromType();
            Class to = mapping.getToType();
            if (ObjectHelper.equal((Object)from, prevFrom) && ObjectHelper.equal((Object)to, prevTo)) {
                ignored = true;
            }
            prevFrom = from;
            prevTo = to;
            Method method = mapping.getMethod();
            Class<?> methodClass = method.getDeclaringClass();
            String packageName = methodClass.getPackage().getName();
            if (packages.containsKey(packageName)) {
                classes = (Set)packages.get(packageName);
            } else {
                classes = new TreeSet();
                packages.put(packageName, classes);
            }
            classes.add(methodClass.getName());
            if (ignored) {
                sink.italic();
                this.tableRow(sink, from.getSimpleName(), to.getSimpleName(), method.getName(), methodClass, mapping.getConverterType().getName());
                sink.italic_();
                continue;
            }
            this.tableRow(sink, from.getSimpleName(), to.getSimpleName(), method.getName(), methodClass, mapping.getConverterType().getName());
        }
        sink.table_();
        this.generatePackageReport(sink, packages);
        this.endReport(sink);
    }

    private void generatePackageReport(org.apache.maven.doxia.sink.Sink sink, Map<String, Set<String>> packages) {
        for (Map.Entry<String, Set<String>> entry : packages.entrySet()) {
            sink.section2();
            sink.sectionTitle2();
            sink.text(entry.getKey());
            sink.sectionTitle2_();
            sink.list();
            for (String clazz : entry.getValue()) {
                sink.listItem();
                sink.anchor(clazz);
                sink.text(clazz);
                sink.anchor_();
                sink.listItem_();
            }
            sink.list_();
            sink.section2_();
        }
    }

    private void beginReport(org.apache.maven.doxia.sink.Sink sink, Locale locale) {
        String title = this.getBundle(locale).getString("report.converters.report.title");
        String header = this.getBundle(locale).getString("report.converters.report.header");
        String intro = this.getBundle(locale).getString("report.converters.report.intro");
        String seealso = this.getBundle(locale).getString("report.converters.report.seealso");
        sink.head();
        sink.title();
        sink.text(title);
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(header);
        sink.sectionTitle1_();
        sink.paragraph();
        sink.text(intro);
        sink.paragraph_();
        sink.paragraph();
        sink.text(seealso);
        sink.list();
        sink.listItem();
        sink.link(WIKI_TYPECONVERER_URL);
        sink.text(WIKI_TYPECONVERER_URL);
        sink.link_();
        sink.listItem_();
        sink.list_();
        sink.paragraph_();
    }

    private void tableHeader(org.apache.maven.doxia.sink.Sink sink, Locale locale) {
        String caption = this.getBundle(locale).getString("report.converters.report.table.caption");
        String head1 = this.getBundle(locale).getString("report.converters.report.table.head1");
        String head2 = this.getBundle(locale).getString("report.converters.report.table.head2");
        String head3 = this.getBundle(locale).getString("report.converters.report.table.head3");
        String head4 = this.getBundle(locale).getString("report.converters.report.table.head4");
        String head5 = this.getBundle(locale).getString("report.converters.report.table.head5");
        sink.tableCaption();
        sink.text(caption);
        sink.tableCaption_();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(head1);
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(head2);
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(head3);
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(head4);
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(head5);
        sink.tableHeaderCell_();
        sink.tableRow();
    }

    private void tableRow(org.apache.maven.doxia.sink.Sink sink, String from, String to, String method, Class<?> clazz, String type) {
        sink.tableRow();
        sink.tableCell();
        sink.text(from);
        sink.tableCell_();
        sink.tableCell();
        sink.text(to);
        sink.tableCell_();
        sink.tableCell();
        sink.text(method);
        sink.tableCell_();
        sink.tableCell();
        sink.link(clazz.getName());
        sink.text(clazz.getSimpleName());
        sink.link_();
        sink.tableCell_();
        sink.tableCell();
        sink.text(this.converterType(type));
        sink.tableCell_();
        sink.tableRow();
    }

    private void endReport(org.apache.maven.doxia.sink.Sink sink) {
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
    }
}

