/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.net.SocketAddress;
import org.apache.camel.CamelException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.mina.MinaEndpoint;
import org.apache.camel.component.mina.MinaExchange;
import org.apache.camel.component.mina.MinaHelper;
import org.apache.camel.component.mina.MinaPayloadHelper;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinaConsumer
extends DefaultConsumer<MinaExchange> {
    private static final transient Log LOG = LogFactory.getLog(MinaConsumer.class);
    private final MinaEndpoint endpoint;
    private final SocketAddress address;
    private final IoAcceptor acceptor;

    public MinaConsumer(MinaEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.address = endpoint.getAddress();
        this.acceptor = endpoint.getAcceptor();
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Binding to server address: " + this.address + " using acceptor: " + this.acceptor));
        }
        this.acceptor.bind(this.address, (IoHandler)new ReceiveHandler(), (IoServiceConfig)this.endpoint.getAcceptorConfig());
    }

    protected void doStop() throws Exception {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Unbinding from server address: " + this.address + " using acceptor: " + this.acceptor));
        }
        this.acceptor.unbind(this.address);
        super.doStop();
    }

    private final class ReceiveHandler
    extends IoHandlerAdapter {
        private ReceiveHandler() {
        }

        public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
            if (session != null) {
                LOG.debug((Object)"Closing session as an exception was thrown from MINA");
                session.close();
            }
            throw new CamelException(cause);
        }

        public void messageReceived(IoSession session, Object object) throws Exception {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Received body: " + object));
            }
            MinaExchange exchange = MinaConsumer.this.endpoint.createExchange(session, object);
            MinaConsumer.this.getProcessor().process((Exchange)exchange);
            if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
                Object body = MinaPayloadHelper.getOut(MinaConsumer.this.endpoint, (Exchange)exchange);
                boolean failed = exchange.isFailed();
                if (failed) {
                    LOG.warn((Object)("Can not write body since the exchange is failed, closing session: " + (Object)((Object)exchange)));
                    session.close();
                } else if (body == null) {
                    LOG.warn((Object)("Can not write body since its null, closing session: " + (Object)((Object)exchange)));
                    session.close();
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Writing body: " + body));
                    }
                    MinaHelper.writeBody(session, body, (Exchange)exchange);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Can not write body since this exchange is not out capable: " + (Object)((Object)exchange)));
            }
        }
    }
}

