/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.converter.IOConverter;
import org.apache.mina.common.ByteBuffer;

@Converter
public final class MinaConverter {
    private MinaConverter() {
    }

    @Converter
    public static byte[] toByteArray(ByteBuffer buffer) {
        byte[] answer = new byte[buffer.remaining()];
        try {
            buffer.acquire();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        buffer.get(answer);
        return answer;
    }

    @Converter
    public static String toString(ByteBuffer buffer, Exchange exchange) {
        return IOConverter.toString((byte[])MinaConverter.toByteArray(buffer), (Exchange)exchange);
    }

    @Converter
    public static InputStream toInputStream(ByteBuffer buffer) {
        return buffer.asInputStream();
    }

    @Converter
    public static ObjectInput toObjectInput(ByteBuffer buffer) throws IOException {
        return IOConverter.toObjectInput((InputStream)MinaConverter.toInputStream(buffer));
    }

    @Converter
    public static ByteBuffer toByteBuffer(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.allocate((int)bytes.length);
        buf.put(bytes);
        return buf;
    }
}

