/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.net.SocketAddress;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mina.MinaComponent;
import org.apache.camel.component.mina.MinaConfiguration;
import org.apache.camel.component.mina.MinaConsumer;
import org.apache.camel.component.mina.MinaExchange;
import org.apache.camel.component.mina.MinaPayloadHelper;
import org.apache.camel.component.mina.MinaProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoAcceptorConfig;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoConnectorConfig;
import org.apache.mina.common.IoSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinaEndpoint
extends DefaultEndpoint<MinaExchange> {
    private SocketAddress address;
    private IoAcceptor acceptor;
    private IoConnector connector;
    private IoAcceptorConfig acceptorConfig;
    private IoConnectorConfig connectorConfig;
    private MinaConfiguration configuration;

    public MinaEndpoint() {
    }

    public MinaEndpoint(String endpointUri, MinaComponent component) {
        super(endpointUri, (Component)component);
    }

    public Producer<MinaExchange> createProducer() throws Exception {
        ObjectHelper.notNull((Object)this.configuration, (String)"configuration");
        ObjectHelper.notNull((Object)this.address, (String)"address");
        ObjectHelper.notNull((Object)this.connector, (String)"connector");
        if (!this.configuration.getProtocol().equalsIgnoreCase("vm")) {
            ObjectHelper.notNull((Object)this.connectorConfig, (String)"connectorConfig");
        }
        return new MinaProducer(this);
    }

    public Consumer<MinaExchange> createConsumer(Processor processor) throws Exception {
        ObjectHelper.notNull((Object)this.configuration, (String)"configuration");
        ObjectHelper.notNull((Object)this.address, (String)"address");
        ObjectHelper.notNull((Object)this.acceptor, (String)"acceptor");
        if (!this.configuration.getProtocol().equalsIgnoreCase("vm")) {
            ObjectHelper.notNull((Object)this.acceptorConfig, (String)"acceptorConfig");
        }
        return new MinaConsumer(this, processor);
    }

    public MinaExchange createExchange(ExchangePattern pattern) {
        return new MinaExchange(this.getCamelContext(), pattern, null);
    }

    public MinaExchange createExchange(IoSession session, Object payload) {
        MinaExchange exchange = new MinaExchange(this.getCamelContext(), this.getExchangePattern(), session);
        MinaPayloadHelper.setIn((Exchange)exchange, payload);
        return exchange;
    }

    public boolean isSingleton() {
        return true;
    }

    public MinaConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MinaConfiguration configuration) {
        this.configuration = configuration;
    }

    public SocketAddress getAddress() {
        return this.address;
    }

    public void setAddress(SocketAddress address) {
        this.address = address;
    }

    public IoAcceptor getAcceptor() {
        return this.acceptor;
    }

    public void setAcceptor(IoAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    public IoConnector getConnector() {
        return this.connector;
    }

    public void setConnector(IoConnector connector) {
        this.connector = connector;
    }

    public IoAcceptorConfig getAcceptorConfig() {
        return this.acceptorConfig;
    }

    public void setAcceptorConfig(IoAcceptorConfig acceptorConfig) {
        this.acceptorConfig = acceptorConfig;
    }

    public IoConnectorConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    public void setConnectorConfig(IoConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
    }
}

