/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.net.SocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.component.mina.MinaEndpoint;
import org.apache.camel.component.mina.MinaHelper;
import org.apache.camel.component.mina.MinaPayloadHelper;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.transport.socket.nio.SocketConnector;

public class MinaProducer
extends DefaultProducer {
    private static final transient Log LOG = LogFactory.getLog(MinaProducer.class);
    private IoSession session;
    private MinaEndpoint endpoint;
    private CountDownLatch latch;
    private boolean lazySessionCreation;
    private long timeout;
    private IoConnector connector;
    private boolean sync;

    public MinaProducer(MinaEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.lazySessionCreation = endpoint.isLazySessionCreation();
        this.timeout = endpoint.getTimeout();
        this.sync = endpoint.isSync();
    }

    public void process(Exchange exchange) throws Exception {
        ResponseHandler handler;
        Object body;
        if (this.session == null && !this.lazySessionCreation) {
            throw new IllegalStateException("Not started yet!");
        }
        if (this.session == null || !this.session.isConnected()) {
            this.openConnection();
        }
        if (this.endpoint.getCharsetName() != null) {
            exchange.setProperty("org.apache.camel.Exchange.CharsetName", (Object)this.endpoint.getCharsetName());
        }
        if ((body = MinaPayloadHelper.getIn(this.endpoint, exchange)) == null) {
            LOG.warn((Object)("No payload to send for exchange: " + exchange));
            return;
        }
        if (this.sync) {
            this.latch = new CountDownLatch(1);
            handler = (ResponseHandler)this.session.getHandler();
            handler.reset();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Writing body: " + body));
        }
        MinaHelper.writeBody(this.session, body, exchange);
        if (this.sync) {
            LOG.debug((Object)"Waiting for response");
            this.latch.await(this.timeout, TimeUnit.MILLISECONDS);
            if (this.latch.getCount() == 1L) {
                throw new ExchangeTimedOutException(exchange, this.timeout);
            }
            handler = (ResponseHandler)this.session.getHandler();
            if (handler.getCause() != null) {
                throw new CamelExchangeException("Response Handler had an exception", exchange, handler.getCause());
            }
            if (!handler.isMessageRecieved()) {
                throw new CamelExchangeException("No response received from remote server: " + this.endpoint.getEndpointUri(), exchange);
            }
            if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
                MinaPayloadHelper.setOut(exchange, handler.getMessage());
            } else {
                MinaPayloadHelper.setIn(exchange, handler.getMessage());
            }
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (!this.lazySessionCreation) {
            this.openConnection();
        }
    }

    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Stopping connector: " + this.connector + " at address: " + this.endpoint.getAddress()));
        }
        if (this.connector instanceof SocketConnector) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Setting SocketConnector WorkerTimeout=0 to force MINA stopping its resources faster");
            }
            ((SocketConnector)this.connector).setWorkerTimeout(0);
        }
        if (this.session != null) {
            this.session.close();
        }
        super.doStop();
    }

    private void openConnection() {
        SocketAddress address = this.endpoint.getAddress();
        this.connector = this.endpoint.getConnector();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating connector to address: " + address + " using connector: " + this.connector + " timeout: " + this.timeout + " millis."));
        }
        ResponseHandler ioHandler = new ResponseHandler(this.endpoint);
        ConnectFuture future = this.connector.connect(address, (IoHandler)ioHandler, (IoServiceConfig)this.endpoint.getConnectorConfig());
        future.join();
        this.session = future.getSession();
    }

    private final class ResponseHandler
    extends IoHandlerAdapter {
        private MinaEndpoint endpoint;
        private Object message;
        private Throwable cause;
        private boolean messageRecieved;

        private ResponseHandler(MinaEndpoint endpoint) {
            this.endpoint = endpoint;
        }

        public void reset() {
            this.message = null;
            this.cause = null;
            this.messageRecieved = false;
        }

        public void messageReceived(IoSession ioSession, Object message) throws Exception {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Message received: " + message));
            }
            this.message = message;
            this.messageRecieved = true;
            this.cause = null;
            this.countDown();
        }

        protected void countDown() {
            CountDownLatch downLatch = MinaProducer.this.latch;
            if (downLatch != null) {
                downLatch.countDown();
            }
        }

        public void sessionClosed(IoSession session) throws Exception {
            if (MinaProducer.this.sync && this.message == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Session closed but no message received from address: " + this.endpoint.getAddress()));
                }
                this.countDown();
            }
        }

        public void exceptionCaught(IoSession ioSession, Throwable cause) {
            LOG.error((Object)("Exception on receiving message from address: " + this.endpoint.getAddress() + " using connector: " + this.endpoint.getConnector()), cause);
            this.message = null;
            this.messageRecieved = false;
            this.cause = cause;
            if (ioSession != null) {
                ioSession.close();
            }
        }

        public Throwable getCause() {
            return this.cause;
        }

        public Object getMessage() {
            return this.message;
        }

        public boolean isMessageRecieved() {
            return this.messageRecieved;
        }
    }
}

