/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.net.SocketAddress;
import org.apache.camel.CamelException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.mina.MinaEndpoint;
import org.apache.camel.component.mina.MinaExchange;
import org.apache.camel.component.mina.MinaHelper;
import org.apache.camel.component.mina.MinaPayloadHelper;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinaConsumer
extends DefaultConsumer<MinaExchange> {
    public static final transient String HEADER_CLOSE_SESSION_WHEN_COMPLETE = "CamelMinaCloseSessionWhenComplete";
    private static final transient Log LOG = LogFactory.getLog(MinaConsumer.class);
    private final MinaEndpoint endpoint;
    private final SocketAddress address;
    private final IoAcceptor acceptor;
    private boolean sync;

    public MinaConsumer(MinaEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.address = endpoint.getAddress();
        this.acceptor = endpoint.getAcceptor();
        this.sync = endpoint.getConfiguration().isSync();
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Binding to server address: " + this.address + " using acceptor: " + this.acceptor));
        }
        this.acceptor.bind(this.address, (IoHandler)new ReceiveHandler(), (IoServiceConfig)this.endpoint.getAcceptorConfig());
    }

    protected void doStop() throws Exception {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Unbinding from server address: " + this.address + " using acceptor: " + this.acceptor));
        }
        this.acceptor.unbind(this.address);
        super.doStop();
    }

    private final class ReceiveHandler
    extends IoHandlerAdapter {
        private ReceiveHandler() {
        }

        public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
            if (session != null) {
                LOG.debug((Object)"Closing session as an exception was thrown from MINA");
                session.close();
            }
            throw new CamelException(cause);
        }

        public void messageReceived(IoSession session, Object object) throws Exception {
            Boolean close;
            if (LOG.isDebugEnabled()) {
                Object in = object;
                if (in instanceof byte[]) {
                    in = MinaConsumer.this.endpoint.getCamelContext().getTypeConverter().convertTo(String.class, in);
                }
                LOG.debug((Object)("Received body: " + in));
            }
            MinaExchange exchange = MinaConsumer.this.endpoint.createExchange(session, object);
            if (MinaConsumer.this.endpoint.getConfiguration().getCharsetName() != null) {
                exchange.setProperty("org.apache.camel.Exchange.CharsetName", MinaConsumer.this.endpoint.getConfiguration().getCharsetName());
            }
            MinaConsumer.this.getProcessor().process((Exchange)exchange);
            if (MinaConsumer.this.sync) {
                Object body = ExchangeHelper.isOutCapable((Exchange)exchange) ? MinaPayloadHelper.getOut(MinaConsumer.this.endpoint, (Exchange)exchange) : MinaPayloadHelper.getIn(MinaConsumer.this.endpoint, (Exchange)exchange);
                boolean failed = exchange.isFailed();
                if (failed && !MinaConsumer.this.endpoint.getConfiguration().isTransferExchange()) {
                    body = exchange.getException() != null ? exchange.getException() : exchange.getFault().getBody();
                }
                if (body == null) {
                    LOG.warn((Object)("Can not write body since its null, closing session: " + (Object)((Object)exchange)));
                    session.close();
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Writing body: " + body));
                    }
                    MinaHelper.writeBody(session, body, (Exchange)exchange);
                }
            }
            if ((close = ExchangeHelper.isOutCapable((Exchange)exchange) ? (Boolean)exchange.getOut().getHeader(MinaConsumer.HEADER_CLOSE_SESSION_WHEN_COMPLETE, Boolean.class) : (Boolean)exchange.getIn().getHeader(MinaConsumer.HEADER_CLOSE_SESSION_WHEN_COMPLETE, Boolean.class)) != null && close.booleanValue()) {
                LOG.debug((Object)"Closing session when complete");
                session.close();
            }
        }
    }
}

