/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.apache.camel.CamelContext;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;

public class MinaUdpProtocolCodecFactory
implements ProtocolCodecFactory {
    private final Charset charset;
    private final CamelContext context;

    public MinaUdpProtocolCodecFactory(CamelContext context, Charset charset) {
        this.context = context;
        this.charset = charset;
    }

    public ProtocolEncoder getEncoder() throws Exception {
        return new ProtocolEncoder(){
            private CharsetEncoder encoder;

            public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
                if (this.encoder == null) {
                    this.encoder = MinaUdpProtocolCodecFactory.this.charset.newEncoder();
                }
                ByteBuffer buf = MinaUdpProtocolCodecFactory.this.toByteBuffer(message, this.encoder);
                buf.flip();
                out.write(buf);
            }

            public void dispose(IoSession session) throws Exception {
            }
        };
    }

    public ProtocolDecoder getDecoder() throws Exception {
        return new ProtocolDecoder(){

            public void decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
                byte[] bytes = (byte[])MinaUdpProtocolCodecFactory.this.context.getTypeConverter().convertTo(byte[].class, (Object)in);
                out.write((Object)bytes);
            }

            public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
            }

            public void dispose(IoSession session) throws Exception {
            }
        };
    }

    private ByteBuffer toByteBuffer(Object message, CharsetEncoder encoder) throws CharacterCodingException {
        boolean tryConvert = true;
        TypeConverter converter = this.context.getTypeConverter();
        if (message != null && converter instanceof DefaultTypeConverter) {
            DefaultTypeConverter defaultTypeConverter = (DefaultTypeConverter)converter;
            boolean bl = tryConvert = !defaultTypeConverter.hasNoConverterFor(String.class, message.getClass());
        }
        if (tryConvert) {
            try {
                String value = (String)converter.convertTo(String.class, message);
                if (value != null) {
                    ByteBuffer answer = ByteBuffer.allocate((int)value.length()).setAutoExpand(true);
                    answer.putString((CharSequence)value, encoder);
                    return answer;
                }
            }
            catch (NoTypeConversionAvailableException ex) {
                // empty catch block
            }
        }
        return (ByteBuffer)this.context.getTypeConverter().convertTo(ByteBuffer.class, message);
    }
}

