/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MinaHelper {
    private static final transient Logger LOG = LoggerFactory.getLogger(MinaHelper.class);

    private MinaHelper() {
    }

    public static void writeBody(IoSession session, Object body, Exchange exchange) throws CamelExchangeException {
        WriteFuture future = session.write(body);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Waiting for write to complete");
        }
        future.join(10000L);
        if (!future.isWritten()) {
            LOG.warn("Cannot write body: " + body + " using session: " + session);
            throw new CamelExchangeException("Cannot write body", exchange);
        }
    }
}

