/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.mina.MinaConfiguration;
import org.apache.camel.component.mina.MinaEndpoint;
import org.apache.camel.component.mina.MinaUdpProtocolCodecFactory;
import org.apache.camel.component.mina.TextLineCodecFactory;
import org.apache.camel.component.mina.TextLineDelimiter;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoAcceptorConfig;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoConnectorConfig;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.LoggingFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.codec.textline.LineDelimiter;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.nio.DatagramAcceptor;
import org.apache.mina.transport.socket.nio.DatagramAcceptorConfig;
import org.apache.mina.transport.socket.nio.DatagramConnector;
import org.apache.mina.transport.socket.nio.DatagramConnectorConfig;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.transport.socket.nio.SocketConnectorConfig;
import org.apache.mina.transport.vmpipe.VmPipeAcceptor;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.VmPipeConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinaComponent
extends DefaultComponent {
    private static final transient Logger LOG = LoggerFactory.getLogger(MinaComponent.class);
    private MinaConfiguration configuration;

    public MinaComponent() {
    }

    public MinaComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MinaConfiguration config = this.configuration != null ? this.configuration.copy() : new MinaConfiguration();
        URI u = new URI(remaining);
        config.setHost(u.getHost());
        config.setPort(u.getPort());
        config.setProtocol(u.getScheme());
        config.setFilters(this.resolveAndRemoveReferenceListParameter(parameters, "filters", IoFilter.class));
        this.setProperties(config, parameters);
        return this.createEndpoint(uri, config);
    }

    public Endpoint createEndpoint(MinaConfiguration config) throws Exception {
        return this.createEndpoint(null, config);
    }

    private Endpoint createEndpoint(String uri, MinaConfiguration config) throws Exception {
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"camelContext");
        String protocol = config.getProtocol();
        if (protocol != null) {
            if (protocol.equals("tcp")) {
                return this.createSocketEndpoint(uri, config);
            }
            if (config.isDatagramProtocol()) {
                return this.createDatagramEndpoint(uri, config);
            }
            if (protocol.equals("vm")) {
                return this.createVmEndpoint(uri, config);
            }
        }
        throw new IllegalArgumentException("Unrecognised MINA protocol: " + protocol + " for uri: " + uri);
    }

    protected MinaEndpoint createVmEndpoint(String uri, MinaConfiguration configuration) {
        boolean minaLogger = configuration.isMinaLogger();
        boolean sync = configuration.isSync();
        List<IoFilter> filters = configuration.getFilters();
        VmPipeAcceptor acceptor = new VmPipeAcceptor();
        VmPipeAddress address = new VmPipeAddress(configuration.getPort());
        VmPipeConnector connector = new VmPipeConnector();
        this.configureCodecFactory("MinaProducer", connector.getDefaultConfig(), configuration);
        if (minaLogger) {
            connector.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        this.appendIoFiltersToChain(filters, connector.getFilterChain());
        this.configureCodecFactory("MinaConsumer", acceptor.getDefaultConfig(), configuration);
        if (minaLogger) {
            acceptor.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        this.appendIoFiltersToChain(filters, acceptor.getFilterChain());
        MinaEndpoint endpoint = new MinaEndpoint(uri, this);
        endpoint.setAddress((SocketAddress)address);
        endpoint.setAcceptor((IoAcceptor)acceptor);
        endpoint.setConnector((IoConnector)connector);
        endpoint.setConfiguration(configuration);
        if (sync) {
            endpoint.setExchangePattern(ExchangePattern.InOut);
        } else {
            endpoint.setExchangePattern(ExchangePattern.InOnly);
        }
        return endpoint;
    }

    protected MinaEndpoint createSocketEndpoint(String uri, MinaConfiguration configuration) {
        boolean minaLogger = configuration.isMinaLogger();
        long timeout = configuration.getTimeout();
        boolean sync = configuration.isSync();
        List<IoFilter> filters = configuration.getFilters();
        int processorCount = Runtime.getRuntime().availableProcessors() + 1;
        SocketAcceptor acceptor = new SocketAcceptor(processorCount, (Executor)this.getCamelContext().getExecutorServiceStrategy().newDefaultThreadPool((Object)this, "MinaSocketAcceptor"));
        SocketConnector connector = new SocketConnector(processorCount, (Executor)this.getCamelContext().getExecutorServiceStrategy().newDefaultThreadPool((Object)this, "MinaSocketConnector"));
        InetSocketAddress address = new InetSocketAddress(configuration.getHost(), configuration.getPort());
        SocketConnectorConfig connectorConfig = new SocketConnectorConfig();
        connectorConfig.setThreadModel(ThreadModel.MANUAL);
        this.configureCodecFactory("MinaProducer", (IoServiceConfig)connectorConfig, configuration);
        connectorConfig.getFilterChain().addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)this.getCamelContext().getExecutorServiceStrategy().newDefaultThreadPool((Object)this, "MinaThreadPool")));
        if (minaLogger) {
            connectorConfig.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        this.appendIoFiltersToChain(filters, connectorConfig.getFilterChain());
        connectorConfig.setConnectTimeout((int)(timeout / 1000L));
        SocketAcceptorConfig acceptorConfig = new SocketAcceptorConfig();
        acceptorConfig.setThreadModel(ThreadModel.MANUAL);
        this.configureCodecFactory("MinaConsumer", (IoServiceConfig)acceptorConfig, configuration);
        acceptorConfig.setReuseAddress(true);
        acceptorConfig.setDisconnectOnUnbind(true);
        acceptorConfig.getFilterChain().addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)this.getCamelContext().getExecutorServiceStrategy().newDefaultThreadPool((Object)this, "MinaThreadPool")));
        if (minaLogger) {
            acceptorConfig.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        this.appendIoFiltersToChain(filters, acceptorConfig.getFilterChain());
        MinaEndpoint endpoint = new MinaEndpoint(uri, this);
        endpoint.setAddress(address);
        endpoint.setAcceptor((IoAcceptor)acceptor);
        endpoint.setAcceptorConfig((IoAcceptorConfig)acceptorConfig);
        endpoint.setConnector((IoConnector)connector);
        endpoint.setConnectorConfig((IoConnectorConfig)connectorConfig);
        endpoint.setConfiguration(configuration);
        if (sync) {
            endpoint.setExchangePattern(ExchangePattern.InOut);
        } else {
            endpoint.setExchangePattern(ExchangePattern.InOnly);
        }
        return endpoint;
    }

    protected void configureCodecFactory(String type, IoServiceConfig config, MinaConfiguration configuration) {
        if (configuration.getCodec() != null) {
            this.addCodecFactory(config, configuration.getCodec());
        } else if (configuration.isAllowDefaultCodec()) {
            this.configureDefaultCodecFactory(type, config, configuration);
        }
    }

    protected void configureDefaultCodecFactory(String type, IoServiceConfig config, MinaConfiguration configuration) {
        if (configuration.isTextline()) {
            Charset charset = MinaComponent.getEncodingParameter(type, configuration);
            LineDelimiter delimiter = MinaComponent.getLineDelimiterParameter(configuration.getTextlineDelimiter());
            TextLineCodecFactory codecFactory = new TextLineCodecFactory(charset, delimiter);
            if (configuration.getEncoderMaxLineLength() > 0) {
                codecFactory.setEncoderMaxLineLength(configuration.getEncoderMaxLineLength());
            }
            if (configuration.getDecoderMaxLineLength() > 0) {
                codecFactory.setDecoderMaxLineLength(configuration.getDecoderMaxLineLength());
            }
            this.addCodecFactory(config, codecFactory);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}: Using TextLineCodecFactory: {} using encoding: {} line delimiter: {}({})", new Object[]{type, codecFactory, charset, configuration.getTextlineDelimiter(), delimiter});
                LOG.debug("Encoder maximum line length: {}. Decoder maximum line length: {}", (Object)codecFactory.getEncoderMaxLineLength(), (Object)codecFactory.getDecoderMaxLineLength());
            }
        } else {
            ObjectSerializationCodecFactory codecFactory = new ObjectSerializationCodecFactory();
            this.addCodecFactory(config, (ProtocolCodecFactory)codecFactory);
            LOG.debug("{}: Using ObjectSerializationCodecFactory: {}", (Object)type, (Object)codecFactory);
        }
    }

    protected MinaEndpoint createDatagramEndpoint(String uri, MinaConfiguration configuration) {
        boolean minaLogger = configuration.isMinaLogger();
        long timeout = configuration.getTimeout();
        boolean transferExchange = configuration.isTransferExchange();
        boolean sync = configuration.isSync();
        List<IoFilter> filters = configuration.getFilters();
        DatagramAcceptor acceptor = new DatagramAcceptor((Executor)this.getCamelContext().getExecutorServiceStrategy().newDefaultThreadPool((Object)this, "MinaDatagramAcceptor"));
        DatagramConnector connector = new DatagramConnector((Executor)this.getCamelContext().getExecutorServiceStrategy().newDefaultThreadPool((Object)this, "MinaDatagramConnector"));
        InetSocketAddress address = new InetSocketAddress(configuration.getHost(), configuration.getPort());
        if (transferExchange) {
            throw new IllegalArgumentException("transferExchange=true is not supported for datagram protocol");
        }
        DatagramConnectorConfig connectorConfig = new DatagramConnectorConfig();
        connectorConfig.setThreadModel(ThreadModel.MANUAL);
        this.configureDataGramCodecFactory("MinaProducer", (IoServiceConfig)connectorConfig, configuration);
        connectorConfig.getFilterChain().addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)this.getCamelContext().getExecutorServiceStrategy().newDefaultThreadPool((Object)this, "MinaThreadPool")));
        if (minaLogger) {
            connectorConfig.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        this.appendIoFiltersToChain(filters, connectorConfig.getFilterChain());
        connectorConfig.setConnectTimeout((int)(timeout / 1000L));
        DatagramAcceptorConfig acceptorConfig = new DatagramAcceptorConfig();
        acceptorConfig.setThreadModel(ThreadModel.MANUAL);
        this.configureDataGramCodecFactory("MinaConsumer", (IoServiceConfig)acceptorConfig, configuration);
        acceptorConfig.setDisconnectOnUnbind(true);
        acceptorConfig.getFilterChain().addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)this.getCamelContext().getExecutorServiceStrategy().newDefaultThreadPool((Object)this, "MinaThreadPool")));
        if (minaLogger) {
            acceptorConfig.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        this.appendIoFiltersToChain(filters, acceptorConfig.getFilterChain());
        MinaEndpoint endpoint = new MinaEndpoint(uri, this);
        endpoint.setAddress(address);
        endpoint.setAcceptor((IoAcceptor)acceptor);
        endpoint.setAcceptorConfig((IoAcceptorConfig)acceptorConfig);
        endpoint.setConnector((IoConnector)connector);
        endpoint.setConnectorConfig((IoConnectorConfig)connectorConfig);
        endpoint.setConfiguration(configuration);
        if (sync) {
            endpoint.setExchangePattern(ExchangePattern.InOut);
        } else {
            endpoint.setExchangePattern(ExchangePattern.InOnly);
        }
        return endpoint;
    }

    protected void configureDataGramCodecFactory(String type, IoServiceConfig config, MinaConfiguration configuration) {
        ProtocolCodecFactory codecFactory = configuration.getCodec();
        if (codecFactory == null) {
            Charset charset = MinaComponent.getEncodingParameter(type, configuration);
            codecFactory = new MinaUdpProtocolCodecFactory(this.getCamelContext(), charset);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}: Using CodecFactory: {} using encoding: {}", new Object[]{type, codecFactory, charset});
            }
        }
        this.addCodecFactory(config, codecFactory);
    }

    private void addCodecFactory(IoServiceConfig config, ProtocolCodecFactory codecFactory) {
        config.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter(codecFactory));
    }

    private static LineDelimiter getLineDelimiterParameter(TextLineDelimiter delimiter) {
        if (delimiter == null) {
            return LineDelimiter.DEFAULT;
        }
        switch (delimiter) {
            case DEFAULT: {
                return LineDelimiter.DEFAULT;
            }
            case AUTO: {
                return LineDelimiter.AUTO;
            }
            case UNIX: {
                return LineDelimiter.UNIX;
            }
            case WINDOWS: {
                return LineDelimiter.WINDOWS;
            }
            case MAC: {
                return LineDelimiter.MAC;
            }
        }
        throw new IllegalArgumentException("Unknown textline delimiter: " + (Object)((Object)delimiter));
    }

    private static Charset getEncodingParameter(String type, MinaConfiguration configuration) {
        String encoding = configuration.getEncoding();
        if (encoding == null) {
            encoding = Charset.defaultCharset().name();
            configuration.setEncoding(encoding);
            LOG.debug("{}: No encoding parameter using default charset: {}", (Object)type, (Object)encoding);
        }
        if (!Charset.isSupported(encoding)) {
            throw new IllegalArgumentException("The encoding: " + encoding + " is not supported");
        }
        return Charset.forName(encoding);
    }

    private void appendIoFiltersToChain(List<IoFilter> filters, DefaultIoFilterChainBuilder filterChain) {
        if (filters != null && filters.size() > 0) {
            for (IoFilter ioFilter : filters) {
                filterChain.addLast(ioFilter.getClass().getCanonicalName(), ioFilter);
            }
        }
    }

    public MinaConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MinaConfiguration configuration) {
        this.configuration = configuration;
    }
}

