/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.net.SocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.ServicePoolAware;
import org.apache.camel.component.mina.MinaEndpoint;
import org.apache.camel.component.mina.MinaHelper;
import org.apache.camel.component.mina.MinaPayloadHelper;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinaProducer
extends DefaultProducer
implements ServicePoolAware {
    private static final transient Logger LOG = LoggerFactory.getLogger(MinaProducer.class);
    private IoSession session;
    private CountDownLatch latch;
    private boolean lazySessionCreation;
    private long timeout;
    private IoConnector connector;
    private boolean sync;
    private CamelLogger noReplyLogger;

    public MinaProducer(MinaEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.lazySessionCreation = endpoint.getConfiguration().isLazySessionCreation();
        this.timeout = endpoint.getConfiguration().getTimeout();
        this.sync = endpoint.getConfiguration().isSync();
        this.noReplyLogger = new CamelLogger(LOG, endpoint.getConfiguration().getNoReplyLogLevel());
    }

    public MinaEndpoint getEndpoint() {
        return (MinaEndpoint)super.getEndpoint();
    }

    public boolean isSingleton() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        try {
            this.doProcess(exchange);
        }
        finally {
            this.maybeDisconnectOnDone(exchange);
        }
    }

    protected void doProcess(Exchange exchange) throws Exception {
        Object body;
        if (this.session == null && !this.lazySessionCreation) {
            throw new IllegalStateException("Not started yet!");
        }
        if (this.session == null || !this.session.isConnected()) {
            this.openConnection();
        }
        if (this.getEndpoint().getConfiguration().getCharsetName() != null) {
            exchange.setProperty("CamelCharsetName", (Object)IOHelper.normalizeCharset((String)this.getEndpoint().getConfiguration().getCharsetName()));
        }
        if ((body = MinaPayloadHelper.getIn(this.getEndpoint(), exchange)) == null) {
            this.noReplyLogger.log("No payload to send for exchange: " + exchange);
            return;
        }
        if (this.getEndpoint().getConfiguration().isTextline()) {
            body = this.getEndpoint().getCamelContext().getTypeConverter().mandatoryConvertTo(String.class, exchange, body);
        }
        if (this.sync) {
            this.latch = new CountDownLatch(1);
            ResponseHandler handler = (ResponseHandler)this.session.getHandler();
            handler.reset();
        }
        if (LOG.isDebugEnabled()) {
            Object out = body;
            if (body instanceof byte[]) {
                out = exchange.getContext().getTypeConverter().convertTo(String.class, body);
            }
            LOG.debug("Writing body : {}", out);
        }
        MinaHelper.writeBody(this.session, body, exchange);
        if (this.sync) {
            LOG.debug("Waiting for response using timeout {} millis.", (Object)this.timeout);
            boolean done = this.latch.await(this.timeout, TimeUnit.MILLISECONDS);
            if (!done) {
                throw new ExchangeTimedOutException(exchange, this.timeout);
            }
            ResponseHandler handler = (ResponseHandler)this.session.getHandler();
            if (handler.getCause() != null) {
                throw new CamelExchangeException("Error occurred in ResponseHandler", exchange, handler.getCause());
            }
            if (!handler.isMessageReceived()) {
                throw new CamelExchangeException("No response received from remote server: " + this.getEndpoint().getEndpointUri(), exchange);
            }
            if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
                MinaPayloadHelper.setOut(exchange, handler.getMessage());
            } else {
                MinaPayloadHelper.setIn(exchange, handler.getMessage());
            }
        }
    }

    protected void maybeDisconnectOnDone(Exchange exchange) {
        if (this.session == null) {
            return;
        }
        Boolean close = ExchangeHelper.isOutCapable((Exchange)exchange) ? (Boolean)exchange.getOut().getHeader("CamelMinaCloseSessionWhenComplete", Boolean.class) : (Boolean)exchange.getIn().getHeader("CamelMinaCloseSessionWhenComplete", Boolean.class);
        boolean disconnect = this.getEndpoint().getConfiguration().isDisconnect();
        if (close != null) {
            disconnect = close;
        }
        if (disconnect) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing session when complete at address: {}", (Object)this.getEndpoint().getAddress());
            }
            this.session.close();
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (!this.lazySessionCreation) {
            this.openConnection();
        }
    }

    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping connector: {} at address: {}", (Object)this.connector, (Object)this.getEndpoint().getAddress());
        }
        this.closeConnection();
        super.doStop();
    }

    private void closeConnection() {
        if (this.connector instanceof SocketConnector) {
            LOG.trace("Setting SocketConnector WorkerTimeout=0 to force MINA stopping its resources faster");
            ((SocketConnector)this.connector).setWorkerTimeout(0);
        }
        if (this.session != null) {
            this.session.close();
        }
    }

    private void openConnection() {
        SocketAddress address = this.getEndpoint().getAddress();
        this.connector = this.getEndpoint().getConnector();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating connector to address: {} using connector: {} timeout: {} millis.", new Object[]{address, this.connector, this.timeout});
        }
        ResponseHandler ioHandler = new ResponseHandler(this.getEndpoint());
        ConnectFuture future = this.connector.connect(address, (IoHandler)ioHandler, (IoServiceConfig)this.getEndpoint().getConnectorConfig());
        future.join();
        this.session = future.getSession();
    }

    private final class ResponseHandler
    extends IoHandlerAdapter {
        private MinaEndpoint endpoint;
        private Object message;
        private Throwable cause;
        private boolean messageReceived;

        private ResponseHandler(MinaEndpoint endpoint) {
            this.endpoint = endpoint;
        }

        public void reset() {
            this.message = null;
            this.cause = null;
            this.messageReceived = false;
        }

        public void messageReceived(IoSession ioSession, Object message) throws Exception {
            LOG.debug("Message received: {}", message);
            this.message = message;
            this.messageReceived = true;
            this.cause = null;
            this.countDown();
        }

        protected void countDown() {
            CountDownLatch downLatch = MinaProducer.this.latch;
            if (downLatch != null) {
                downLatch.countDown();
            }
        }

        public void sessionClosed(IoSession session) throws Exception {
            if (MinaProducer.this.sync && !this.messageReceived) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Session closed but no message received from address: {}", (Object)this.endpoint.getAddress());
                }
                this.countDown();
            }
        }

        public void exceptionCaught(IoSession ioSession, Throwable cause) {
            LOG.error("Exception on receiving message from address: " + this.endpoint.getAddress() + " using connector: " + this.endpoint.getConnector(), cause);
            this.message = null;
            this.messageReceived = false;
            this.cause = cause;
            if (ioSession != null) {
                ioSession.close();
            }
        }

        public Throwable getCause() {
            return this.cause;
        }

        public Object getMessage() {
            return this.message;
        }

        public boolean isMessageReceived() {
            return this.messageReceived;
        }
    }
}

