/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mllp.MllpComponent;
import org.apache.camel.component.mllp.MllpTcpClientProducer;
import org.apache.camel.component.mllp.MllpTcpServerConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="mllp", title="mllp", syntax="mllp:hostname:port", consumerClass=MllpTcpServerConsumer.class, label="mllp")
public class MllpEndpoint
extends DefaultEndpoint {
    public static final char START_OF_BLOCK = '\u000b';
    public static final char END_OF_BLOCK = '\u001c';
    public static final char END_OF_DATA = '\r';
    public static final int END_OF_STREAM = -1;
    public static final char SEGMENT_DELIMITER = '\r';
    public static final char MESSAGE_TERMINATOR = '\n';
    private static final Logger LOG = LoggerFactory.getLogger(MllpEndpoint.class);
    @UriPath(defaultValue="0.0.0.0", description="Hostname or IP for connection")
    String hostname = "0.0.0.0";
    @UriPath(description="TCP Port for connection")
    int port = -1;
    @UriParam(defaultValue="5", description="TCP Server only - The maximum queue length for incoming connection indications (a request to connect) is set to the backlog parameter. If a connection indication arrives when the queue is full, the connection is refused.")
    int backlog = 5;
    @UriParam(defaultValue="30000", description="TCP Server only - timeout value while waiting for a TCP listener to start (milliseconds)")
    int bindTimeout = 30000;
    @UriParam(defaultValue="30000", description="TCP Server only - timeout value while waiting for a TCP connection (milliseconds)")
    int acceptTimeout = 30000;
    @UriParam(defaultValue="30000", description="TCP Client only - timeout value while establishing for a TCP connection (milliseconds)")
    int connectTimeout = 30000;
    @UriParam(defaultValue="5000", description="Timeout value (milliseconds) used when reading a message from an external")
    int responseTimeout = 5000;
    @UriParam(defaultValue="true", description="Enable/disable the SO_KEEPALIVE socket option.")
    boolean keepAlive = true;
    @UriParam(defaultValue="true", description="Enable/disable the TCP_NODELAY socket option.")
    boolean tcpNoDelay = true;
    @UriParam(defaultValue="false", description="Enable/disable the SO_REUSEADDR socket option.")
    boolean reuseAddress;
    @UriParam(description="Sets the SO_RCVBUF option to the specified value")
    Integer receiveBufferSize;
    @UriParam(description="Sets the SO_SNDBUF option to the specified value")
    Integer sendBufferSize;
    @UriParam(defaultValue="0", description="The amount of time a TCP connection can remain idle before it is closed")
    int idleTimeout;
    @UriParam(description="The TCP mode of the endpoint (client or server).  Defaults to client for Producers and server for Consumers")
    String tcpMode;
    @UriParam(defaultValue="true", description="MLLP Consumers only - Automatically generate and send an MLLP Acknowledgement")
    boolean autoAck = true;
    @UriParam(description="Set the CamelCharsetName property on the exchange")
    String charsetName;

    public MllpEndpoint(String uri, MllpComponent component) {
        super(uri, (Component)component);
        int optionsStartIndex = uri.indexOf(63);
        String hostPort = -1 == optionsStartIndex ? uri.substring(7) : uri.substring(7, optionsStartIndex);
        int colonIndex = hostPort.indexOf(58);
        if (-1 != colonIndex) {
            this.hostname = hostPort.substring(0, colonIndex);
            this.port = Integer.parseInt(hostPort.substring(colonIndex + 1));
        } else {
            this.port = Integer.parseInt(hostPort);
        }
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    public Exchange createExchange(ExchangePattern exchangePattern) {
        Exchange mllpExchange = super.createExchange(exchangePattern);
        this.setExchangeProperties(mllpExchange);
        return mllpExchange;
    }

    public Exchange createExchange(Exchange exchange) {
        Exchange mllpExchange = super.createExchange(exchange);
        this.setExchangeProperties(mllpExchange);
        return mllpExchange;
    }

    private void setExchangeProperties(Exchange mllpExchange) {
        if (this.charsetName != null) {
            mllpExchange.setProperty("CamelCharsetName", (Object)this.charsetName);
        }
    }

    public Producer createProducer() throws Exception {
        LOG.trace("({}).createProducer()", (Object)this.getEndpointKey());
        return new MllpTcpClientProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        LOG.trace("({}).createConsumer(processor)", (Object)this.getEndpointKey());
        MllpTcpServerConsumer consumer = new MllpTcpServerConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public boolean isSynchronous() {
        return true;
    }

    public boolean isSingleton() {
        return true;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public int getAcceptTimeout() {
        return this.acceptTimeout;
    }

    public void setAcceptTimeout(int acceptTimeout) {
        this.acceptTimeout = acceptTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(int responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public boolean isAutoAck() {
        return this.autoAck;
    }

    public void setAutoAck(boolean autoAck) {
        this.autoAck = autoAck;
    }
}

