/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.mllp.MllpEndpoint;
import org.apache.camel.component.mllp.MllpException;
import org.apache.camel.component.mllp.MllpInvalidAcknowledgementException;
import org.apache.camel.component.mllp.impl.MllpUtil;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.processor.mllp.Hl7AcknowledgementGenerationException;
import org.apache.camel.processor.mllp.Hl7AcknowledgementGenerator;
import org.apache.camel.util.IOHelper;

public class MllpTcpServerConsumer
extends DefaultConsumer {
    ServerSocketThread serverSocketThread;
    List<ClientSocketThread> clientThreads = new LinkedList<ClientSocketThread>();
    private final MllpEndpoint endpoint;

    public MllpTcpServerConsumer(MllpEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.log.trace("MllpTcpServerConsumer(endpoint, processor)");
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        this.log.debug("doStart() - creating acceptor thread");
        ServerSocket serverSocket = new ServerSocket();
        if (null != this.endpoint.receiveBufferSize) {
            serverSocket.setReceiveBufferSize(this.endpoint.receiveBufferSize);
        }
        serverSocket.setReuseAddress(this.endpoint.reuseAddress);
        serverSocket.setSoTimeout(this.endpoint.acceptTimeout);
        InetSocketAddress socketAddress = new InetSocketAddress(this.endpoint.getHostname(), this.endpoint.getPort());
        serverSocket.bind(socketAddress, this.endpoint.backlog);
        this.serverSocketThread = new ServerSocketThread(serverSocket);
        this.serverSocketThread.start();
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.log.debug("doStop()");
        switch (this.serverSocketThread.getState()) {
            case TERMINATED: {
                break;
            }
            default: {
                this.serverSocketThread.interrupt();
            }
        }
        this.serverSocketThread = null;
        super.doStop();
    }

    protected void doSuspend() throws Exception {
        this.log.debug("doSuspend()");
        super.doSuspend();
    }

    protected void doResume() throws Exception {
        this.log.debug("doResume()");
        super.doSuspend();
    }

    protected void doShutdown() throws Exception {
        this.log.debug("doShutdown()");
        super.doShutdown();
    }

    class ClientSocketThread
    extends Thread {
        Socket clientSocket;
        Hl7AcknowledgementGenerator acknowledgementGenerator = new Hl7AcknowledgementGenerator();
        Integer initialByte;

        ClientSocketThread(Socket clientSocket, Integer initialByte) throws IOException {
            this.initialByte = initialByte;
            this.setName(this.createThreadName(clientSocket));
            this.clientSocket = clientSocket;
            this.clientSocket.setKeepAlive(((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.keepAlive);
            this.clientSocket.setTcpNoDelay(((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.tcpNoDelay);
            if (null != ((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.receiveBufferSize) {
                this.clientSocket.setReceiveBufferSize(((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.receiveBufferSize);
            }
            if (null != ((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.sendBufferSize) {
                this.clientSocket.setSendBufferSize(((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.sendBufferSize);
            }
            this.clientSocket.setReuseAddress(((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.reuseAddress);
            this.clientSocket.setSoLinger(false, -1);
            this.clientSocket.setSoTimeout(((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.responseTimeout);
        }

        String createThreadName(Socket socket) {
            String fullClassName = this.getClass().getName();
            String className = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
            String fullEndpointKey = MllpTcpServerConsumer.this.endpoint.getEndpointKey();
            String endpointKey = fullEndpointKey.contains("?") ? fullEndpointKey.substring(0, fullEndpointKey.indexOf(63)) : fullEndpointKey;
            return String.format("%s[%s] - %s -> %s", className, endpointKey, socket.getLocalSocketAddress(), socket.getRemoteSocketAddress());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (null != this.clientSocket && this.clientSocket.isConnected() && !this.clientSocket.isClosed()) {
                byte[] hl7MessageBytes;
                block39: {
                    hl7MessageBytes = null;
                    MllpTcpServerConsumer.this.log.debug("Reading data ....");
                    try {
                        if (null != this.initialByte && 11 == this.initialByte) {
                            hl7MessageBytes = MllpUtil.closeFrame(this.clientSocket);
                            break block39;
                        }
                        try {
                            MllpUtil.openFrame(this.clientSocket);
                        }
                        catch (SocketTimeoutException timeoutEx) {
                            this.initialByte = null;
                            continue;
                        }
                        hl7MessageBytes = MllpUtil.closeFrame(this.clientSocket);
                    }
                    catch (MllpException mllpEx) {
                        Exchange exchange = MllpTcpServerConsumer.this.endpoint.createExchange(ExchangePattern.InOut);
                        exchange.setException((Throwable)mllpEx);
                        return;
                    }
                    finally {
                        this.initialByte = null;
                    }
                }
                if (null == hl7MessageBytes) continue;
                MllpTcpServerConsumer.this.log.debug("Populating the exchange with received message");
                Exchange exchange = MllpTcpServerConsumer.this.endpoint.createExchange(ExchangePattern.InOut);
                Message message = exchange.getIn();
                message.setBody((Object)hl7MessageBytes, byte[].class);
                message.setHeader("CamelMllpLocalAddress", (Object)this.clientSocket.getLocalAddress().toString());
                message.setHeader("CamelMllpRemoteAddress", (Object)this.clientSocket.getRemoteSocketAddress());
                this.populateHl7DataHeaders(exchange, message, hl7MessageBytes);
                MllpTcpServerConsumer.this.log.debug("Calling processor");
                try {
                    String acknowledgementMessageType;
                    byte[] acknowledgementMessageBytes;
                    block40: {
                        MllpTcpServerConsumer.this.getProcessor().process(exchange);
                        if (((Boolean)exchange.getProperty("CamelMllpResetConnectionBeforeSend", Boolean.TYPE)).booleanValue()) {
                            MllpUtil.resetConnection(this.clientSocket);
                            return;
                        }
                        if (((Boolean)exchange.getProperty("CamelMllpCloseConnectionBeforeSend", Boolean.TYPE)).booleanValue()) {
                            MllpUtil.closeConnection(this.clientSocket);
                        }
                        acknowledgementMessageBytes = (byte[])exchange.getProperty("CamelMllpAcknowledgement", byte[].class);
                        acknowledgementMessageType = null;
                        if (null == acknowledgementMessageBytes) {
                            if (!((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.autoAck) {
                                exchange.setException((Throwable)new MllpInvalidAcknowledgementException("Automatic Acknowledgement is disabled and the CamelMllpAcknowledgement exchange property is null or cannot be converted to byte[]"));
                                return;
                            }
                            String acknowledgmentTypeProperty = (String)exchange.getProperty("CamelMllpAcknowledgementType", String.class);
                            try {
                                if (null == acknowledgmentTypeProperty) {
                                    if (null == exchange.getException()) {
                                        acknowledgementMessageType = "AA";
                                        acknowledgementMessageBytes = this.acknowledgementGenerator.generateApplicationAcceptAcknowledgementMessage(hl7MessageBytes);
                                    } else {
                                        acknowledgementMessageType = "AE";
                                        acknowledgementMessageBytes = this.acknowledgementGenerator.generateApplicationErrorAcknowledgementMessage(hl7MessageBytes);
                                    }
                                    break block40;
                                }
                                switch (acknowledgmentTypeProperty) {
                                    case "AA": {
                                        acknowledgementMessageType = "AA";
                                        acknowledgementMessageBytes = this.acknowledgementGenerator.generateApplicationAcceptAcknowledgementMessage(hl7MessageBytes);
                                        break;
                                    }
                                    case "AE": {
                                        acknowledgementMessageType = "AE";
                                        acknowledgementMessageBytes = this.acknowledgementGenerator.generateApplicationErrorAcknowledgementMessage(hl7MessageBytes);
                                        break;
                                    }
                                    case "AR": {
                                        acknowledgementMessageType = "AR";
                                        acknowledgementMessageBytes = this.acknowledgementGenerator.generateApplicationRejectAcknowledgementMessage(hl7MessageBytes);
                                        break;
                                    }
                                    default: {
                                        exchange.setException((Throwable)new Hl7AcknowledgementGenerationException("Unsupported acknowledgment type: " + acknowledgmentTypeProperty));
                                        return;
                                    }
                                }
                            }
                            catch (Hl7AcknowledgementGenerationException ackGenerationException) {
                                exchange.setException((Throwable)ackGenerationException);
                            }
                        } else {
                            int bM = 77;
                            int bS = 83;
                            int bA = 65;
                            int bE = 69;
                            int bR = 82;
                            byte fieldSeparator = hl7MessageBytes[3];
                            for (int i = 0; i < hl7MessageBytes.length; ++i) {
                                String acknowledgementTypeProperty;
                                if (13 != i || i + 7 >= hl7MessageBytes.length || 77 != hl7MessageBytes[i + 1] || 83 != hl7MessageBytes[i + 2] || 65 != hl7MessageBytes[i + 3] || fieldSeparator != hl7MessageBytes[i + 4]) continue;
                                if (fieldSeparator != hl7MessageBytes[i + 7]) {
                                    MllpTcpServerConsumer.this.log.warn("MSA-1 is longer than 2-bytes - ignoring trailing bytes");
                                }
                                byte[] acknowledgmentTypeBytes = new byte[]{hl7MessageBytes[i + 5], hl7MessageBytes[i + 6]};
                                acknowledgementMessageType = IOConverter.toString((byte[])acknowledgmentTypeBytes, (Exchange)exchange);
                                if (65 != acknowledgmentTypeBytes[0]) {
                                    switch (acknowledgementMessageBytes[1]) {
                                        case 65: 
                                        case 69: 
                                        case 82: {
                                            break;
                                        }
                                        default: {
                                            MllpTcpServerConsumer.this.log.warn("Invalid acknowledgement type [" + acknowledgementMessageType + "] found in message - should be AA, AE or AR");
                                        }
                                    }
                                }
                                if (null == (acknowledgementTypeProperty = (String)exchange.getProperty("CamelMllpAcknowledgementType", String.class)) || acknowledgementTypeProperty.equals(acknowledgementMessageType)) continue;
                                MllpTcpServerConsumer.this.log.warn("Acknowledgement type found in message [" + acknowledgementMessageType + "] does not match " + "CamelMllpAcknowledgementType" + " exchange property value [" + acknowledgementTypeProperty + "] - using value found in message");
                            }
                        }
                    }
                    MllpTcpServerConsumer.this.log.debug("Writing Acknowledgement");
                    MllpUtil.writeFramedPayload(this.clientSocket, acknowledgementMessageBytes);
                    exchange.getIn().setHeader("CamelMllpAcknowledgement", (Object)acknowledgementMessageBytes);
                    exchange.getIn().setHeader("CamelMllpAcknowledgementType", (Object)acknowledgementMessageType);
                    if (((Boolean)exchange.getProperty("CamelMllpResetConnectionAfterSend", Boolean.TYPE)).booleanValue()) {
                        MllpUtil.resetConnection(this.clientSocket);
                        return;
                    }
                    if (!((Boolean)exchange.getProperty("CamelMllpCloseConnectionAfterSend", Boolean.TYPE)).booleanValue()) continue;
                    MllpUtil.closeConnection(this.clientSocket);
                }
                catch (Exception e) {
                    exchange.setException((Throwable)e);
                }
            }
            MllpTcpServerConsumer.this.log.info("ClientSocketThread exiting");
        }

        private void populateHl7DataHeaders(Exchange exchange, Message message, byte[] hl7MessageBytes) {
            byte fieldSeparator = hl7MessageBytes[3];
            byte componentSeparator = hl7MessageBytes[4];
            int endOfMSH = -1;
            ArrayList<Integer> fieldSeparatorIndexes = new ArrayList<Integer>(10);
            for (int i = 0; i < hl7MessageBytes.length; ++i) {
                if (fieldSeparator == hl7MessageBytes[i]) {
                    fieldSeparatorIndexes.add(i);
                    continue;
                }
                if (13 != hl7MessageBytes[i]) continue;
                endOfMSH = i;
                break;
            }
            if (-1 == endOfMSH) {
                MllpTcpServerConsumer.this.log.error("Population of message headers failed - unable to find the end of the MSH segment");
            } else {
                MllpTcpServerConsumer.this.log.debug("Populating the message headers");
                Charset charset = Charset.forName(IOHelper.getCharsetName((Exchange)exchange));
                message.setHeader("CamelMllpSendingApplication", (Object)new String(hl7MessageBytes, (Integer)fieldSeparatorIndexes.get(1) + 1, (Integer)fieldSeparatorIndexes.get(2) - (Integer)fieldSeparatorIndexes.get(1) - 1, charset));
                message.setHeader("CamelMllpSendingFacility", (Object)new String(hl7MessageBytes, (Integer)fieldSeparatorIndexes.get(2) + 1, (Integer)fieldSeparatorIndexes.get(3) - (Integer)fieldSeparatorIndexes.get(2) - 1, charset));
                message.setHeader("CamelMllpReceivingApplication", (Object)new String(hl7MessageBytes, (Integer)fieldSeparatorIndexes.get(3) + 1, (Integer)fieldSeparatorIndexes.get(4) - (Integer)fieldSeparatorIndexes.get(3) - 1, charset));
                message.setHeader("CamelMllpReceivingFacility", (Object)new String(hl7MessageBytes, (Integer)fieldSeparatorIndexes.get(4) + 1, (Integer)fieldSeparatorIndexes.get(5) - (Integer)fieldSeparatorIndexes.get(4) - 1, charset));
                message.setHeader("CamelMllpTimestamp", (Object)new String(hl7MessageBytes, (Integer)fieldSeparatorIndexes.get(5) + 1, (Integer)fieldSeparatorIndexes.get(6) - (Integer)fieldSeparatorIndexes.get(5) - 1, charset));
                message.setHeader("CamelMllpSecurity", (Object)new String(hl7MessageBytes, (Integer)fieldSeparatorIndexes.get(6) + 1, (Integer)fieldSeparatorIndexes.get(7) - (Integer)fieldSeparatorIndexes.get(6) - 1, charset));
                message.setHeader("CamelMllpMessageType", (Object)new String(hl7MessageBytes, (Integer)fieldSeparatorIndexes.get(7) + 1, (Integer)fieldSeparatorIndexes.get(8) - (Integer)fieldSeparatorIndexes.get(7) - 1, charset));
                message.setHeader("CamelMllpMessageControlId", (Object)new String(hl7MessageBytes, (Integer)fieldSeparatorIndexes.get(8) + 1, (Integer)fieldSeparatorIndexes.get(9) - (Integer)fieldSeparatorIndexes.get(8) - 1, charset));
                message.setHeader("CamelMllpProcessingId", (Object)new String(hl7MessageBytes, (Integer)fieldSeparatorIndexes.get(9) + 1, (Integer)fieldSeparatorIndexes.get(10) - (Integer)fieldSeparatorIndexes.get(9) - 1, charset));
                message.setHeader("CamelMllpVersionId", (Object)new String(hl7MessageBytes, (Integer)fieldSeparatorIndexes.get(10) + 1, (Integer)fieldSeparatorIndexes.get(11) - (Integer)fieldSeparatorIndexes.get(10) - 1, charset));
                message.setHeader("CamelMllpCharset", (Object)new String(hl7MessageBytes, (Integer)fieldSeparatorIndexes.get(16) + 1, (Integer)fieldSeparatorIndexes.get(17) - (Integer)fieldSeparatorIndexes.get(16) - 1, charset));
                for (int i = (Integer)fieldSeparatorIndexes.get(7) + 1; i < (Integer)fieldSeparatorIndexes.get(8); ++i) {
                    if (componentSeparator != hl7MessageBytes[i]) continue;
                    message.setHeader("CamelMllpEventType", (Object)new String(hl7MessageBytes, (Integer)fieldSeparatorIndexes.get(7) + 1, i - (Integer)fieldSeparatorIndexes.get(7) - 1, charset));
                    message.setHeader("CamelMllpTriggerEvent", (Object)new String(hl7MessageBytes, i + 1, (Integer)fieldSeparatorIndexes.get(8) - i - 1, charset));
                    break;
                }
            }
        }
    }

    class ServerSocketThread
    extends Thread {
        ServerSocket serverSocket;

        ServerSocketThread(ServerSocket serverSocket) {
            this.setName(this.createThreadName(serverSocket));
            this.serverSocket = serverSocket;
        }

        String createThreadName(ServerSocket serverSocket) {
            String fullClassName = this.getClass().getName();
            String className = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
            String fullEndpointKey = MllpTcpServerConsumer.this.endpoint.getEndpointKey();
            String endpointKey = fullEndpointKey.contains("?") ? fullEndpointKey.substring(0, fullEndpointKey.indexOf(63)) : fullEndpointKey;
            return String.format("%s[%s] - %s", className, endpointKey, serverSocket.getLocalSocketAddress());
        }

        @Override
        public void run() {
            MllpTcpServerConsumer.this.log.debug("Starting acceptor thread");
            while (null != this.serverSocket && this.serverSocket.isBound() && !this.serverSocket.isClosed()) {
                try {
                    ClientSocketThread clientThread;
                    InputStream inputStream;
                    Socket socket = this.serverSocket.accept();
                    Thread.sleep(100L);
                    if (!socket.isConnected() || socket.isClosed()) continue;
                    MllpTcpServerConsumer.this.log.debug("Socket appears to be there - check for available data");
                    try {
                        inputStream = socket.getInputStream();
                    }
                    catch (IOException ioEx) {
                        MllpTcpServerConsumer.this.log.warn("Failed to retrieve the InputStream for socket after the initial connection was accepted");
                        MllpUtil.resetConnection(socket);
                        continue;
                    }
                    if (0 < inputStream.available()) {
                        ClientSocketThread clientThread2 = new ClientSocketThread(socket, null);
                        MllpTcpServerConsumer.this.clientThreads.add(clientThread2);
                        clientThread2.start();
                        continue;
                    }
                    socket.setSoTimeout(100);
                    try {
                        int tmpByte = inputStream.read();
                        socket.setSoTimeout(((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.responseTimeout);
                        if (-1 == tmpByte) {
                            MllpTcpServerConsumer.this.log.debug("Socket.read() returned END_OF_STREAM - resetting connection");
                            MllpUtil.resetConnection(socket);
                            continue;
                        }
                        clientThread = new ClientSocketThread(socket, tmpByte);
                        MllpTcpServerConsumer.this.clientThreads.add(clientThread);
                        clientThread.start();
                    }
                    catch (SocketTimeoutException timeoutEx) {
                        MllpTcpServerConsumer.this.log.debug("No Data - but the socket is there.  Starting ClientSocketThread");
                        clientThread = new ClientSocketThread(socket, null);
                        MllpTcpServerConsumer.this.clientThreads.add(clientThread);
                        clientThread.start();
                    }
                }
                catch (SocketTimeoutException timeoutEx) {
                    MllpTcpServerConsumer.this.log.trace("SocketTimeoutException waiting for new connections - no new connections");
                    for (int i = MllpTcpServerConsumer.this.clientThreads.size() - 1; i >= 0; --i) {
                        ClientSocketThread thread = MllpTcpServerConsumer.this.clientThreads.get(i);
                        if (thread.isAlive()) continue;
                        MllpTcpServerConsumer.this.clientThreads.remove(i);
                    }
                }
                catch (InterruptedException interruptEx) {
                    MllpTcpServerConsumer.this.log.info("accept loop interrupted - closing ServerSocket");
                    try {
                        this.serverSocket.close();
                    }
                    catch (Exception ex) {
                        MllpTcpServerConsumer.this.log.warn("Exception encountered closing ServerSocket after InterruptedException", (Throwable)ex);
                    }
                }
                catch (Exception ex) {
                    MllpTcpServerConsumer.this.log.error("Exception accepting new connection", (Throwable)ex);
                }
            }
        }
    }
}

