/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp.impl;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.camel.component.mllp.MllpCorruptFrameException;
import org.apache.camel.component.mllp.MllpException;
import org.apache.camel.component.mllp.MllpTimeoutException;
import org.apache.camel.component.mllp.MllpWriteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MllpUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MllpUtil.class);

    private MllpUtil() {
    }

    public static void openFrame(Socket socket) throws SocketTimeoutException, MllpCorruptFrameException, MllpException {
        if (socket.isConnected() && !socket.isClosed()) {
            int readByte;
            InputStream socketInputStream = MllpUtil.getInputStream(socket);
            try {
                readByte = socketInputStream.read();
                switch (readByte) {
                    case 11: {
                        return;
                    }
                    case -1: {
                        MllpUtil.resetConnection(socket);
                        return;
                    }
                }
            }
            catch (SocketTimeoutException normaTimeoutEx) {
                throw normaTimeoutEx;
            }
            catch (IOException unexpectedException) {
                LOG.error("Unexpected Exception occurred opening MLLP frame - resetting the connection");
                MllpUtil.resetConnection(socket);
                throw new MllpException("Unexpected Exception occurred opening MLLP frame", unexpectedException);
            }
            ByteArrayOutputStream outOfFrameData = new ByteArrayOutputStream();
            outOfFrameData.write(readByte);
            try {
                while (true) {
                    readByte = socketInputStream.read();
                    switch (readByte) {
                        case -1: {
                            if (MllpUtil.isLogPHIEnabled(LOG)) {
                                LOG.error("END_OF_STREAM read while looking for the beginning of the MLLP frame, and out-of-frame data had been read - resetting connection and eating out-of-frame data: {}", (Object)outOfFrameData.toString().replace('\r', '\n'));
                            } else {
                                LOG.error("END_OF_STREAM read while looking for the beginning of the MLLP frame, and out-of-frame data had been read - resetting connection and eating out-of-frame data");
                            }
                            MllpUtil.resetConnection(socket);
                            throw new MllpCorruptFrameException("END_OF_STREAM read while looking for the beginning of the MLLP frame", outOfFrameData.toByteArray());
                        }
                        case 11: {
                            if (MllpUtil.isLogPHIEnabled(LOG)) {
                                LOG.warn("The beginning of the MLLP frame was preceded by out-of-frame data - eating data: {}", (Object)outOfFrameData.toString().replace('\r', '\n'));
                            } else {
                                LOG.warn("The beginning of the MLLP frame was preceded by out-of-frame data - eating data");
                            }
                            throw new MllpCorruptFrameException("The beginning of the MLLP frame was preceded by out-of-frame data", outOfFrameData.toByteArray());
                        }
                    }
                    outOfFrameData.write(readByte);
                }
            }
            catch (SocketTimeoutException timeoutEx) {
                if (MllpUtil.isLogPHIEnabled(LOG)) {
                    LOG.error("Timeout looking for the beginning of the MLLP frame, and out-of-frame data had been read - resetting connection and eating out-of-frame data: {}", (Object)outOfFrameData.toString().replace('\r', '\n'));
                } else {
                    LOG.error("Timeout looking for the beginning of the MLLP frame, and out-of-frame data had been read - resetting connection and eating out-of-frame data");
                }
                MllpUtil.resetConnection(socket);
                throw new MllpCorruptFrameException("Timeout looking for the beginning of the MLLP frame, and out-of-frame data had been read", outOfFrameData.toByteArray());
            }
            catch (IOException e) {
                if (MllpUtil.isLogPHIEnabled(LOG)) {
                    LOG.error("Exception encountered looking for the beginning of the MLLP frame, and out-of-frame data had been read - resetting connection and eating out-of-frame data: {}", (Object)outOfFrameData.toString().replace('\r', '\n'));
                } else {
                    LOG.error("Exception encountered looking for the beginning of the MLLP frame, and out-of-frame data had been read - resetting connection and eating out-of-frame data");
                }
                MllpUtil.resetConnection(socket);
                throw new MllpCorruptFrameException("Exception encountered looking for the beginning of the MLLP frame, and out-of-frame data had been read", outOfFrameData.toByteArray());
            }
        }
    }

    public static byte[] closeFrame(Socket socket) throws MllpTimeoutException, MllpCorruptFrameException, MllpException {
        if (socket.isConnected() && !socket.isClosed()) {
            InputStream socketInputStream = MllpUtil.getInputStream(socket);
            ByteArrayOutputStream payload = new ByteArrayOutputStream(4096);
            try {
                while (true) {
                    int readByte = socketInputStream.read();
                    switch (readByte) {
                        case -1: {
                            if (MllpUtil.isLogPHIEnabled(LOG)) {
                                LOG.error("END_OF_STREAM read while looking for the end of the MLLP frame - resetting connection and eating data: {}", (Object)payload.toString().replace('\r', '\n'));
                            } else {
                                LOG.error("END_OF_STREAM read while looking for the end of the MLLP frame - resetting connection and eating data");
                            }
                            MllpUtil.resetConnection(socket);
                            throw new MllpCorruptFrameException("END_OF_STREAM read while looking for the end of the MLLP frame", payload.size() > 0 ? payload.toByteArray() : null);
                        }
                        case 11: {
                            if (MllpUtil.isLogPHIEnabled(LOG)) {
                                LOG.error("A new MLLP frame was opened before the previous frame was closed - resetting connection and eating data: {}", (Object)payload.toString().replace('\r', '\n'));
                            } else {
                                LOG.error("A new MLLP frame was opened before the previous frame was closed - resetting connection and eating data");
                            }
                            MllpUtil.resetConnection(socket);
                            throw new MllpCorruptFrameException("A new MLLP frame was opened before the previous frame was closed", payload.size() > 0 ? payload.toByteArray() : null);
                        }
                        case 28: {
                            if (13 != socketInputStream.read()) {
                                if (MllpUtil.isLogPHIEnabled(LOG)) {
                                    LOG.error("The MLLP frame was partially closed - END_OF_BLOCK was not followed by END_OF_DATA - resetting connection and eating data: {}", (Object)payload.toString().replace('\r', '\n'));
                                } else {
                                    LOG.error("The MLLP frame was partially closed - END_OF_BLOCK was not followed by END_OF_DATA - resetting connection and eating data");
                                }
                                MllpUtil.resetConnection(socket);
                                throw new MllpCorruptFrameException("The MLLP frame was partially closed - END_OF_BLOCK was not followed by END_OF_DATA", payload.size() > 0 ? payload.toByteArray() : null);
                            }
                            return payload.toByteArray();
                        }
                    }
                    payload.write(readByte);
                }
            }
            catch (SocketTimeoutException timeoutEx) {
                if (0 < payload.size()) {
                    if (MllpUtil.isLogPHIEnabled(LOG)) {
                        LOG.error("Timeout looking for the end of the MLLP frame - resetting connection and eating data: {}", (Object)payload.toString().replace('\r', '\n'));
                    } else {
                        LOG.error("Timeout looking for the end of the MLLP frame - resetting connection and eating data");
                    }
                } else {
                    LOG.error("Timeout looking for the end of the MLLP frame - resetting connection");
                }
                MllpUtil.resetConnection(socket);
                throw new MllpCorruptFrameException("Timeout looking for the end of the MLLP frame", payload.size() > 0 ? payload.toByteArray() : null, timeoutEx);
            }
            catch (IOException ioEx) {
                if (0 < payload.size()) {
                    if (MllpUtil.isLogPHIEnabled(LOG)) {
                        LOG.error("Exception encountered looking for the end of the MLLP frame - resetting connection and eating data: {}", (Object)payload.toString().replace('\r', '\n'));
                    } else {
                        LOG.error("Exception encountered looking for the end of the MLLP frame - resetting connection and eating data");
                    }
                } else {
                    LOG.error("Exception encountered looking for the end of the MLLP frame - resetting connection");
                }
                MllpUtil.resetConnection(socket);
                throw new MllpException("Exception encountered looking for the end of the MLLP frame", payload.size() > 0 ? payload.toByteArray() : null, ioEx);
            }
        }
        return null;
    }

    public static void writeFramedPayload(Socket socket, byte[] payload) throws MllpException {
        if (socket.isConnected() && !socket.isClosed()) {
            BufferedOutputStream outputStream;
            try {
                outputStream = new BufferedOutputStream(socket.getOutputStream(), payload.length + 4);
            }
            catch (IOException ioEx) {
                LOG.error("Error Retrieving OutputStream from Socket - resetting connection");
                MllpUtil.resetConnection(socket);
                throw new MllpException("Error Retrieving OutputStream from Socket", ioEx);
            }
            if (null != outputStream) {
                try {
                    ((OutputStream)outputStream).write(11);
                    ((OutputStream)outputStream).write(payload, 0, payload.length);
                    ((OutputStream)outputStream).write(28);
                    ((OutputStream)outputStream).write(13);
                    ((OutputStream)outputStream).flush();
                }
                catch (IOException ioEx) {
                    LOG.error("Error writing MLLP payload - resetting connection");
                    MllpUtil.resetConnection(socket);
                    throw new MllpWriteException("Error writing MLLP payload", payload, ioEx);
                }
            }
        }
    }

    public static void closeConnection(Socket socket) {
        if (null != socket && !socket.isClosed()) {
            try {
                socket.shutdownInput();
            }
            catch (Exception ex) {
                LOG.warn("Exception encountered shutting down the input stream on the client socket", (Throwable)ex);
            }
            try {
                socket.shutdownOutput();
            }
            catch (Exception ex) {
                LOG.warn("Exception encountered shutting down the output stream on the client socket", (Throwable)ex);
            }
            try {
                socket.close();
            }
            catch (Exception ex) {
                LOG.warn("Exception encountered closing the client socket", (Throwable)ex);
            }
        }
    }

    public static void resetConnection(Socket socket) {
        if (null != socket) {
            try {
                socket.setSoLinger(true, 0);
            }
            catch (Exception ex) {
                LOG.warn("Exception encountered setting SO_LINGER to 0 on the socket to force a reset", (Throwable)ex);
            }
            try {
                socket.close();
            }
            catch (Exception ex) {
                LOG.warn("Exception encountered closing the client socket", (Throwable)ex);
            }
        }
    }

    private static InputStream getInputStream(Socket socket) throws MllpException {
        InputStream socketInputStream = null;
        try {
            socketInputStream = socket.getInputStream();
        }
        catch (IOException ioEx) {
            throw new MllpException("Error Retrieving InputStream from Socket", ioEx);
        }
        return socketInputStream;
    }

    private static boolean isLogPHIEnabled(Logger targetLogger) {
        return targetLogger.isDebugEnabled() && Boolean.parseBoolean(System.getProperty("org.apache.camel.mllp.logPHI", "true"));
    }
}

