/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.WriteConcern;
import org.apache.camel.component.mongodb.MongoDbTailTrackingConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbTailTrackingManager {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbTailTrackingManager.class);
    public Object lastVal;
    private final Mongo connection;
    private final MongoDbTailTrackingConfig config;
    private DBCollection dbCol;
    private DBObject trackingObj;

    public MongoDbTailTrackingManager(Mongo connection, MongoDbTailTrackingConfig config) {
        this.connection = connection;
        this.config = config;
    }

    public void initialize() throws Exception {
        if (!this.config.persistent) {
            return;
        }
        this.dbCol = this.connection.getDB(this.config.db).getCollection(this.config.collection);
        BasicDBObject filter = new BasicDBObject("persistentId", (Object)this.config.persistentId);
        this.trackingObj = this.dbCol.findOne((DBObject)filter);
        if (this.trackingObj == null) {
            this.dbCol.insert((DBObject)filter, WriteConcern.SAFE);
            this.trackingObj = this.dbCol.findOne((DBObject)filter);
        }
        this.trackingObj = new BasicDBObject("_id", this.trackingObj.get("_id"));
    }

    public synchronized void persistToStore() {
        if (!this.config.persistent || this.lastVal == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Persisting lastVal={} to store, collection: {}", this.lastVal, (Object)this.config.collection);
        }
        DBObject updateObj = BasicDBObjectBuilder.start().add("$set", (Object)new BasicDBObject(this.config.field, this.lastVal)).get();
        this.dbCol.update(this.trackingObj, updateObj, false, false, WriteConcern.SAFE);
        this.trackingObj = this.dbCol.findOne();
    }

    public synchronized Object recoverFromStore() {
        if (!this.config.persistent) {
            return null;
        }
        this.lastVal = this.dbCol.findOne(this.trackingObj).get(this.config.field);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Recovered lastVal={} from store, collection: {}", this.lastVal, (Object)this.config.collection);
        }
        return this.lastVal;
    }

    public void setLastVal(DBObject o) {
        if (this.config.increasingField == null) {
            return;
        }
        this.lastVal = o.get(this.config.increasingField);
    }

    public String getIncreasingFieldName() {
        return this.config.increasingField;
    }
}

