/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.msmq;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.msmq.MsmqEndpoint;
import org.apache.camel.component.msmq.Task;
import org.apache.camel.component.msmq.native_support.MsmqQueue;
import org.apache.camel.impl.DefaultConsumer;

public class MsmqConsumer
extends DefaultConsumer {
    private final ConcurrentLinkedQueue<MsmqQueue> queues = new ConcurrentLinkedQueue();
    private final int concurrentConsumers;
    private int initialBufferSize = 128;
    private int incrementBufferSize = 128;
    private final ScheduledThreadPoolExecutor executor;

    public MsmqConsumer(MsmqEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.concurrentConsumers = endpoint.getConcurrentConsumers();
        this.initialBufferSize = endpoint.getInitialBufferSize();
        this.incrementBufferSize = endpoint.getIncrementBufferSize();
        this.executor = new ScheduledThreadPoolExecutor(this.concurrentConsumers);
    }

    protected void doStart() throws Exception {
        this.openQueues();
        for (int i = 0; i < this.concurrentConsumers; ++i) {
            Task worker = new Task((MsmqEndpoint)this.getEndpoint(), this, this.queues, this.getProcessor());
            this.executor.scheduleWithFixedDelay(worker, 0L, 1L, TimeUnit.NANOSECONDS);
        }
    }

    protected void doStop() throws Exception {
        this.executor.shutdown();
        this.closeQueues();
    }

    private void openQueues() {
        for (int i = 0; i < this.concurrentConsumers; ++i) {
            this.queues.add(new MsmqQueue());
        }
    }

    private void closeQueues() {
        for (MsmqQueue queue : this.queues) {
            if (!queue.isOpen()) continue;
            queue.close();
        }
    }

    public int getIncrementBufferSize() {
        return this.incrementBufferSize;
    }

    public int getInitialBufferSize() {
        return this.initialBufferSize;
    }
}

