/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.msmq;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.msmq.MsmqComponent;
import org.apache.camel.component.msmq.MsmqConsumer;
import org.apache.camel.component.msmq.MsmqProducer;
import org.apache.camel.component.msmq.native_support.msmq_native_support;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultExchange;

public class MsmqEndpoint
extends DefaultEndpoint {
    private final String remaining;
    private final Map parameters;
    private boolean deliveryPersistent;
    private int timeToLive = msmq_native_support.INFINITE;
    private int priority = 3;
    private int concurrentConsumers = 1;
    private int initialBufferSize = 128;
    private int incrementBufferSize = 128;

    public MsmqEndpoint(String endpointUri, String remaining, Map parameters, MsmqComponent component) {
        super(endpointUri, (Component)component);
        this.remaining = remaining;
        this.parameters = parameters;
        this.setExchangePattern(ExchangePattern.InOnly);
    }

    public Producer createProducer() throws Exception {
        return new MsmqProducer(this);
    }

    public DefaultExchange createExchange() {
        return new DefaultExchange(this.getCamelContext(), this.getExchangePattern());
    }

    public boolean isSingleton() {
        return true;
    }

    public String getRemaining() {
        return this.remaining;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new MsmqConsumer(this, processor);
    }

    public void setDeliveryPersistent(boolean deliveryPersistent) {
        this.deliveryPersistent = deliveryPersistent;
    }

    public boolean getDeliveryPersistent() {
        return this.deliveryPersistent;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public void setInitialBufferSize(int initialBufferSize) {
        this.initialBufferSize = initialBufferSize;
    }

    public int getInitialBufferSize() {
        return this.initialBufferSize;
    }

    public void setIncrementBufferSize(int incrementBufferSize) {
        this.incrementBufferSize = incrementBufferSize;
    }

    public int getIncrementBufferSize() {
        return this.incrementBufferSize;
    }
}

