/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.msmq;

import java.nio.ByteBuffer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.msmq.MsmqEndpoint;
import org.apache.camel.component.msmq.native_support.MsmqMessage;
import org.apache.camel.component.msmq.native_support.MsmqQueue;
import org.apache.camel.component.msmq.native_support.msmq_native_support;
import org.apache.camel.impl.DefaultProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MsmqProducer
extends DefaultProducer {
    private static final transient Log LOG = LogFactory.getLog(MsmqProducer.class);
    private final MsmqQueue queue;
    private boolean deliveryPersistent;
    private int timeToLive = msmq_native_support.INFINITE;
    private int priority = 3;

    public MsmqProducer(MsmqEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.queue = new MsmqQueue();
        this.deliveryPersistent = endpoint.getDeliveryPersistent();
        this.timeToLive = endpoint.getTimeToLive();
        this.priority = endpoint.getPriority();
    }

    public void process(Exchange exchange) throws Exception {
        if (!this.queue.isOpen()) {
            this.openConnection();
        }
        Object obj = exchange.getIn().getBody();
        ByteBuffer body = null;
        if (obj instanceof ByteBuffer && !(body = (ByteBuffer)obj).isDirect()) {
            ByteBuffer outBuffer = ByteBuffer.allocateDirect(body.remaining());
            outBuffer.put(body);
            outBuffer.flip();
            body = outBuffer;
        }
        if (obj instanceof String) {
            ByteBuffer buffer = ByteBuffer.allocateDirect(((String)obj).length() * 2);
            buffer.asCharBuffer().put((String)obj);
            body = buffer;
        }
        if (body == null) {
            LOG.warn((Object)("No payload for exchange: " + exchange));
        } else {
            MsmqMessage msmqMessage = new MsmqMessage();
            msmqMessage.setMsgBodyWithByteBuffer(body);
            if (this.deliveryPersistent) {
                msmqMessage.setDelivery(msmq_native_support.MQMSG_DELIVERY_RECOVERABLE);
            }
            msmqMessage.setTimeToBeReceived(this.timeToLive);
            msmqMessage.setPriority(this.priority);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Sending body: " + body));
            }
            this.queue.sendMessage(msmqMessage);
        }
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
        if (this.queue.isOpen()) {
            this.queue.close();
        }
    }

    private void openConnection() {
        this.queue.open(((MsmqEndpoint)this.getEndpoint()).getRemaining(), msmq_native_support.MQ_SEND_ACCESS);
    }
}

