/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.msmq;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.msmq.MsmqConsumer;
import org.apache.camel.component.msmq.MsmqEndpoint;
import org.apache.camel.component.msmq.native_support.MsmqMessage;
import org.apache.camel.component.msmq.native_support.MsmqQueue;
import org.apache.camel.component.msmq.native_support.msmq_native_supportConstants;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Task
implements Runnable {
    private final MsmqEndpoint endpoint;
    private final MsmqConsumer consumer;
    private final ConcurrentLinkedQueue<MsmqQueue> queues;
    private final Processor processor;

    public Task(MsmqEndpoint endpoint, MsmqConsumer consumer, ConcurrentLinkedQueue<MsmqQueue> queues, Processor processor) {
        this.endpoint = endpoint;
        this.consumer = consumer;
        this.queues = queues;
        this.processor = processor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        int size = this.queues.size();
        MsmqQueue queue = size == 1 ? (MsmqQueue)this.queues.element() : null;
        try {
            DefaultExchange exchange = this.endpoint.createExchange();
            if (size > 1) {
                queue = (MsmqQueue)this.queues.remove();
            }
            if (!queue.isOpen()) {
                queue.open(this.endpoint.getRemaining(), msmq_native_supportConstants.MQ_RECEIVE_ACCESS);
            }
            int initsize = this.consumer.getInitialBufferSize();
            int incrsize = this.consumer.getIncrementBufferSize();
            boolean cont = true;
            ByteBuffer body = ByteBuffer.allocateDirect(initsize);
            MsmqMessage msmqMessage = new MsmqMessage();
            msmqMessage.setMsgBodyWithByteBuffer(body);
            while (cont) {
                try {
                    if (!queue.receiveMessage(msmqMessage, 100)) continue;
                    Message message = exchange.getIn();
                    message.setBody((Object)body);
                    message.setHeader("APPSPECIFIC", (Object)msmqMessage.getAppSpecific());
                    message.setHeader("ARRIVEDTIME", (Object)msmqMessage.getArrivedTime());
                    message.setHeader("BODY_SIZE", (Object)msmqMessage.getBodySize());
                    message.setHeader("BODY_TYPE", (Object)msmqMessage.getBodyType());
                    message.setHeader("DELIVERY", (Object)msmqMessage.getDelivery());
                    message.setHeader("PRIORITY", (Object)msmqMessage.getPriority());
                    message.setHeader("SENTTIME", (Object)msmqMessage.getSentTime());
                    message.setHeader("TIME_TO_BE_RECEIVED", (Object)msmqMessage.getTimeToBeReceived());
                    this.processor.process((Exchange)exchange);
                    cont = false;
                }
                catch (RuntimeException ex) {
                    if (!ex.getMessage().equals("Message body too big")) throw ex;
                    body = ByteBuffer.allocateDirect(initsize += incrsize);
                    msmqMessage.setMsgBodyWithByteBuffer(body);
                    continue;
                    return;
                }
            }
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        finally {
            if (size > 1) {
                this.queues.add(queue);
            }
        }
    }
}

