/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.msmq.native_support;

import org.apache.camel.component.msmq.native_support.MsmqMessage;
import org.apache.camel.component.msmq.native_support.msmq_native_supportJNI;

public class MsmqQueue {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected MsmqQueue(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(MsmqQueue obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            msmq_native_supportJNI.delete_MsmqQueue(this.swigCPtr);
        }
        this.swigCPtr = 0L;
    }

    public MsmqQueue() {
        this(msmq_native_supportJNI.new_MsmqQueue(), true);
    }

    public void open(String szMSMQQueuePath, int openmode) {
        msmq_native_supportJNI.MsmqQueue_open(this.swigCPtr, this, szMSMQQueuePath, openmode);
    }

    public void sendMessage(MsmqMessage msg) {
        msmq_native_supportJNI.MsmqQueue_sendMessage(this.swigCPtr, this, MsmqMessage.getCPtr(msg), msg);
    }

    public boolean receiveMessage(MsmqMessage msg, int timeout) {
        return msmq_native_supportJNI.MsmqQueue_receiveMessage(this.swigCPtr, this, MsmqMessage.getCPtr(msg), msg, timeout);
    }

    public void close() {
        msmq_native_supportJNI.MsmqQueue_close(this.swigCPtr, this);
    }

    public boolean isOpen() {
        return msmq_native_supportJNI.MsmqQueue_isOpen(this.swigCPtr, this);
    }

    public static void createQueue(String pathName) {
        msmq_native_supportJNI.MsmqQueue_createQueue(pathName);
    }

    public static void deleteQueue(String formatPathName) {
        msmq_native_supportJNI.MsmqQueue_deleteQueue(formatPathName);
    }
}

