/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.msmq.native_support;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.util.IOHelper;

public class NativeLibraryLoader {
    public static void loadLibrary(String libname) throws IOException {
        String actualLibName = System.mapLibraryName(libname);
        File lib = NativeLibraryLoader.extractResource(actualLibName);
        System.load(lib.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File extractResource(String resourcename) throws IOException {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcename);
        if (in == null) {
            throw new IOException("Unable to find library " + resourcename + " on classpath");
        }
        File tmpDir = new File(System.getProperty("java.tmpdir", "tmplib"));
        if (!tmpDir.exists() && !tmpDir.mkdirs()) {
            throw new IOException("Unable to create JNI library working directory " + tmpDir);
        }
        File outfile = new File(tmpDir, resourcename);
        FileOutputStream out = new FileOutputStream(outfile);
        try {
            IOHelper.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            ((OutputStream)out).close();
            in.close();
        }
        return outfile;
    }
}

