/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mybatis;

import java.util.Iterator;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.mybatis.MyBatisEndpoint;
import org.apache.camel.component.mybatis.StatementType;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyBatisProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MyBatisProducer.class);
    private String statement;
    private MyBatisEndpoint endpoint;

    public MyBatisProducer(MyBatisEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.statement = endpoint.getStatement();
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.endpoint.getStatementType()) {
            case SelectOne: {
                this.doSelectOne(exchange);
                break;
            }
            case SelectList: {
                this.doSelectList(exchange);
                break;
            }
            case Insert: {
                this.doInsert(exchange);
                break;
            }
            case Update: {
                this.doUpdate(exchange);
                break;
            }
            case Delete: {
                this.doDelete(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported statementType: " + (Object)((Object)this.endpoint.getStatementType()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSelectOne(Exchange exchange) throws Exception {
        SqlSessionFactory client = this.endpoint.getSqlSessionFactory();
        SqlSession session = client.openSession();
        try {
            Object result;
            Object in = exchange.getIn().getBody();
            if (in != null) {
                LOG.trace("SelectOne: {} using statement: {}", in, (Object)this.statement);
                result = session.selectOne(this.statement, in);
            } else {
                LOG.trace("SelectOne using statement: {}", (Object)this.statement);
                result = session.selectOne(this.statement);
            }
            this.doProcessResult(exchange, result);
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSelectList(Exchange exchange) throws Exception {
        SqlSessionFactory client = this.endpoint.getSqlSessionFactory();
        SqlSession session = client.openSession();
        try {
            List result;
            Object in = exchange.getIn().getBody();
            if (in != null) {
                LOG.trace("SelectList: {} using statement: {}", in, (Object)this.statement);
                result = session.selectList(this.statement, in);
            } else {
                LOG.trace("SelectList using statement: {}", (Object)this.statement);
                result = session.selectList(this.statement);
            }
            this.doProcessResult(exchange, result);
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInsert(Exchange exchange) throws Exception {
        SqlSessionFactory client = this.endpoint.getSqlSessionFactory();
        SqlSession session = client.openSession();
        try {
            Object in = exchange.getIn().getBody();
            if (in != null) {
                Iterator iter = ObjectHelper.createIterator((Object)in);
                while (iter.hasNext()) {
                    Object value = iter.next();
                    LOG.trace("Inserting: {} using statement: {}", value, (Object)this.statement);
                    Integer result = session.insert(this.statement, value);
                    this.doProcessResult(exchange, result);
                }
            } else {
                LOG.trace("Inserting using statement: {}", (Object)this.statement);
                Integer result = session.insert(this.statement);
                this.doProcessResult(exchange, result);
            }
        }
        finally {
            session.commit();
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(Exchange exchange) throws Exception {
        SqlSessionFactory client = this.endpoint.getSqlSessionFactory();
        SqlSession session = client.openSession();
        try {
            Object in = exchange.getIn().getBody();
            if (in != null) {
                Iterator iter = ObjectHelper.createIterator((Object)in);
                while (iter.hasNext()) {
                    Object value = iter.next();
                    LOG.trace("Updating: {} using statement: {}", value, (Object)this.statement);
                    Integer result = session.update(this.statement, value);
                    this.doProcessResult(exchange, result);
                }
            } else {
                LOG.trace("Updating using statement: {}", (Object)this.statement);
                Integer result = session.update(this.statement);
                this.doProcessResult(exchange, result);
            }
        }
        finally {
            session.commit();
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDelete(Exchange exchange) throws Exception {
        SqlSessionFactory client = this.endpoint.getSqlSessionFactory();
        SqlSession session = client.openSession();
        try {
            Object in = exchange.getIn().getBody();
            if (in != null) {
                Iterator iter = ObjectHelper.createIterator((Object)in);
                while (iter.hasNext()) {
                    Object value = iter.next();
                    LOG.trace("Deleting: {} using statement: {}", value, (Object)this.statement);
                    Integer result = session.delete(this.statement, value);
                    this.doProcessResult(exchange, result);
                }
            } else {
                LOG.trace("Deleting using statement: {}", (Object)this.statement);
                Integer result = session.delete(this.statement);
                this.doProcessResult(exchange, result);
            }
        }
        finally {
            session.commit();
            session.close();
        }
    }

    private void doProcessResult(Exchange exchange, Object result) {
        if (this.endpoint.getStatementType() == StatementType.SelectList || this.endpoint.getStatementType() == StatementType.SelectOne) {
            Message answer = exchange.getIn();
            if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
                answer = exchange.getOut();
                answer.getHeaders().putAll(exchange.getIn().getHeaders());
            }
            answer.setBody(result);
            answer.setHeader("CamelMyBatisResult", result);
            answer.setHeader("CamelMyBatisStatementName", (Object)this.statement);
        } else {
            Message msg = exchange.getIn();
            msg.setHeader("CamelMyBatisResult", result);
            msg.setHeader("CamelMyBatisStatementName", (Object)this.statement);
        }
    }
}

