/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nagios;

import com.googlecode.jsendnsca.core.INagiosPassiveCheckSender;
import com.googlecode.jsendnsca.core.Level;
import com.googlecode.jsendnsca.core.MessagePayload;
import com.googlecode.jsendnsca.core.NonBlockingNagiosPassiveCheckSender;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.nagios.NagiosEndpoint;
import org.apache.camel.impl.DefaultProducer;

public class NagiosProducer
extends DefaultProducer {
    private final INagiosPassiveCheckSender sender;

    public NagiosProducer(NagiosEndpoint endpoint, INagiosPassiveCheckSender sender) {
        super((Endpoint)endpoint);
        this.sender = sender;
    }

    public void process(Exchange exchange) throws Exception {
        String message = (String)exchange.getIn().getBody(String.class);
        Level level = (Level)exchange.getIn().getHeader("CamelNagiosLevel", Level.class);
        if (level == null) {
            String name = (String)exchange.getIn().getHeader("CamelNagiosLevel", (Object)Level.OK.name(), String.class);
            level = Level.valueOf((String)name);
        }
        String serviceName = (String)exchange.getIn().getHeader("CamelNagiosServiceName", (Object)exchange.getContext().getName(), String.class);
        String hostName = (String)exchange.getIn().getHeader("CamelNagiosHostName", (Object)"localhost", String.class);
        MessagePayload payload = new MessagePayload(hostName, level.ordinal(), serviceName, message);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sending notification to Nagios: " + payload.getMessage()));
        }
        this.sender.send(payload);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Sending notification done");
        }
    }

    protected void doStart() throws Exception {
        if (this.sender instanceof NonBlockingNagiosPassiveCheckSender) {
            NonBlockingNagiosPassiveCheckSender nonBlocking = (NonBlockingNagiosPassiveCheckSender)this.sender;
            ExecutorService executor = this.getEndpoint().getCamelContext().getExecutorServiceStrategy().newSingleThreadExecutor((Object)this, this.getEndpoint().getEndpointUri());
            nonBlocking.setExecutor(executor);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.sender instanceof NonBlockingNagiosPassiveCheckSender) {
            ((NonBlockingNagiosPassiveCheckSender)this.sender).shutdown();
        }
    }
}

