/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.netty.http.NettyChannelBufferStreamCache;
import org.apache.camel.component.netty.http.NettyHttpBinding;
import org.apache.camel.component.netty.http.NettyHttpConfiguration;
import org.apache.camel.component.netty.http.NettyHttpHelper;
import org.apache.camel.component.netty.http.NettyHttpMessage;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNettyHttpBinding
implements NettyHttpBinding {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNettyHttpBinding.class);
    private HeaderFilterStrategy headerFilterStrategy;

    public DefaultNettyHttpBinding() {
    }

    public DefaultNettyHttpBinding(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    @Override
    public Message toCamelMessage(HttpRequest request, Exchange exchange, NettyHttpConfiguration configuration) throws Exception {
        LOG.trace("toCamelMessage: {}", (Object)request);
        NettyHttpMessage answer = new NettyHttpMessage(request, null);
        answer.setExchange(exchange);
        if (configuration.isMapHeaders()) {
            this.populateCamelHeaders(request, (Map<String, Object>)answer.getHeaders(), exchange, configuration);
        }
        if (configuration.isDisableStreamCache()) {
            answer.setBody(request.getContent());
        } else {
            NettyChannelBufferStreamCache cache = new NettyChannelBufferStreamCache(request.getContent());
            answer.setBody(cache);
        }
        return answer;
    }

    @Override
    public void populateCamelHeaders(HttpRequest request, Map<String, Object> headers, Exchange exchange, NettyHttpConfiguration configuration) throws Exception {
        String http;
        LOG.trace("populateCamelHeaders: {}", (Object)request);
        headers.put("CamelHttpMethod", request.getMethod().getName());
        String s = request.getUri();
        if (s.contains("?")) {
            s = ObjectHelper.before((String)s, (String)"?");
        }
        String string = http = configuration.isSsl() ? "https://" : "http://";
        if (!s.startsWith(http)) {
            s = configuration.getPort() != 80 ? http + configuration.getHost() + ":" + configuration.getPort() + s : http + configuration.getHost() + s;
        }
        headers.put("CamelHttpUrl", s);
        URI uri = new URI(request.getUri());
        headers.put("CamelHttpUri", uri.getPath());
        headers.put("CamelHttpQuery", uri.getQuery());
        String path = uri.getPath();
        if (configuration.getPath() != null && path.startsWith(configuration.getPath())) {
            path = path.substring(configuration.getPath().length());
        }
        headers.put("CamelHttpPath", path);
        if (LOG.isTraceEnabled()) {
            LOG.trace("HTTP-Method {}", (Object)request.getMethod().getName());
            LOG.trace("HTTP-Uri {}", (Object)request.getUri());
        }
        for (String name : request.getHeaderNames()) {
            String value;
            if (name.toLowerCase(Locale.US).equals("content-type")) {
                name = "Content-Type";
            }
            if (name.toLowerCase(Locale.US).equals("authorization") && (value = request.getHeader(name)) != null && value.trim().startsWith("Basic") && this.headerFilterStrategy != null && !this.headerFilterStrategy.applyFilterToExternalHeaders("CamelHttpAuthentication", (Object)"Basic", exchange)) {
                NettyHttpHelper.appendHeader(headers, "CamelHttpAuthentication", "Basic");
            }
            List values = request.getHeaders(name);
            Iterator it = ObjectHelper.createIterator((Object)values);
            while (it.hasNext()) {
                Object extracted = it.next();
                String decoded = this.shouldUrlDecodeHeader(configuration, name, extracted, "UTF-8");
                LOG.trace("HTTP-header: {}", extracted);
                if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, (Object)decoded, exchange)) continue;
                NettyHttpHelper.appendHeader(headers, name, decoded);
            }
        }
        if (request.getUri().contains("?")) {
            String query = ObjectHelper.after((String)request.getUri(), (String)"?");
            Map uriParameters = URISupport.parseQuery((String)query);
            for (Map.Entry entry : uriParameters.entrySet()) {
                String name = (String)entry.getKey();
                Object values = entry.getValue();
                Iterator it = ObjectHelper.createIterator(values);
                while (it.hasNext()) {
                    Object extracted = it.next();
                    String decoded = this.shouldUrlDecodeHeader(configuration, name, extracted, "UTF-8");
                    LOG.trace("URI-Parameter: {}", extracted);
                    if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, (Object)decoded, exchange)) continue;
                    NettyHttpHelper.appendHeader(headers, name, decoded);
                }
            }
        }
        if (request.getMethod().getName().equals("POST") && request.getHeader("Content-Type") != null && request.getHeader("Content-Type").startsWith("application/x-www-form-urlencoded")) {
            String charset = "UTF-8";
            String body = request.getContent().toString(Charset.forName(charset));
            if (ObjectHelper.isNotEmpty((Object)body)) {
                for (String param : body.split("&")) {
                    String[] pair = param.split("=", 2);
                    if (pair.length == 2) {
                        String name = this.shouldUrlDecodeHeader(configuration, "", pair[0], charset);
                        String value = this.shouldUrlDecodeHeader(configuration, name, pair[1], charset);
                        if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, (Object)value, exchange)) continue;
                        NettyHttpHelper.appendHeader(headers, name, value);
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid parameter, expected to be a pair but was " + param);
                }
            }
        }
    }

    protected String shouldUrlDecodeHeader(NettyHttpConfiguration configuration, String headerName, Object value, String charset) throws UnsupportedEncodingException {
        if ("Content-Type".equals(headerName)) {
            return value.toString();
        }
        if (configuration.isUrlDecodeHeaders()) {
            return URLDecoder.decode(value.toString(), charset);
        }
        return value.toString();
    }

    @Override
    public Message toCamelMessage(HttpResponse response, Exchange exchange, NettyHttpConfiguration configuration) throws Exception {
        LOG.trace("toCamelMessage: {}", (Object)response);
        NettyHttpMessage answer = new NettyHttpMessage(null, response);
        answer.setExchange(exchange);
        if (configuration.isMapHeaders()) {
            this.populateCamelHeaders(response, (Map<String, Object>)answer.getHeaders(), exchange, configuration);
        }
        answer.setBody(response.getContent());
        return answer;
    }

    @Override
    public void populateCamelHeaders(HttpResponse response, Map<String, Object> headers, Exchange exchange, NettyHttpConfiguration configuration) throws Exception {
        LOG.trace("populateCamelHeaders: {}", (Object)response);
        headers.put("CamelHttpResponseCode", response.getStatus().getCode());
        headers.put("CamelHttpResponseText", response.getStatus().getReasonPhrase());
        for (String name : response.getHeaderNames()) {
            if (name.toLowerCase().equals("content-type")) {
                name = "Content-Type";
            }
            List values = response.getHeaders(name);
            Iterator it = ObjectHelper.createIterator((Object)values);
            while (it.hasNext()) {
                Object extracted = it.next();
                LOG.trace("HTTP-header: {}", extracted);
                if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, extracted, exchange)) continue;
                NettyHttpHelper.appendHeader(headers, name, extracted);
            }
        }
    }

    @Override
    public HttpResponse toNettyResponse(Message message, NettyHttpConfiguration configuration) throws Exception {
        String connection;
        String contentType;
        ChannelBuffer buffer;
        LOG.trace("toNettyResponse: {}", (Object)message);
        if (message.getBody() instanceof HttpResponse) {
            return (HttpResponse)message.getBody();
        }
        boolean failed = message.getExchange().isFailed();
        int defaultCode = failed ? 500 : 200;
        int code = (Integer)message.getHeader("CamelHttpResponseCode", (Object)defaultCode, Integer.TYPE);
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)code));
        LOG.trace("HTTP Status Code: {}", (Object)code);
        TypeConverter tc = message.getExchange().getContext().getTypeConverter();
        for (Map.Entry entry : message.getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Iterator it = ObjectHelper.createIterator(value, null);
            while (it.hasNext()) {
                String headerValue = (String)tc.convertTo(String.class, it.next());
                if (headerValue == null || this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(key, (Object)headerValue, message.getExchange())) continue;
                LOG.trace("HTTP-Header: {}={}", (Object)key, (Object)headerValue);
                response.addHeader(key, (Object)headerValue);
            }
        }
        Object body = message.getBody();
        Exception cause = message.getExchange().getException();
        if (cause != null) {
            if (configuration.isTransferException()) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(cause);
                oos.flush();
                IOHelper.close((Closeable[])new Closeable[]{oos, bos});
                body = ChannelBuffers.copiedBuffer((byte[])bos.toByteArray());
                message.setHeader("Content-Type", (Object)"application/x-java-serialized-object");
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                cause.printStackTrace(pw);
                body = ChannelBuffers.copiedBuffer((byte[])sw.toString().getBytes());
                message.setHeader("Content-Type", (Object)"text/plain");
            }
            ExchangeHelper.setFailureHandled((Exchange)message.getExchange());
        }
        if (body instanceof ChannelBuffer) {
            buffer = (ChannelBuffer)body;
        } else {
            buffer = (ChannelBuffer)message.getBody(ChannelBuffer.class);
            if (buffer == null) {
                byte[] data = (byte[])message.getBody(byte[].class);
                if (data != null) {
                    buffer = ChannelBuffers.copiedBuffer((byte[])data);
                } else {
                    String str = body != null ? (String)message.getMandatoryBody(String.class) : "";
                    buffer = ChannelBuffers.copiedBuffer((byte[])str.getBytes());
                }
            }
        }
        if (buffer != null) {
            response.setContent(buffer);
            if (buffer.readerIndex() == buffer.writerIndex()) {
                buffer.setIndex(0, buffer.writerIndex());
            }
            int len = buffer.readableBytes();
            response.setHeader("Content-Length", (Object)len);
            LOG.trace("Content-Length: {}", (Object)len);
        }
        if ((contentType = MessageHelper.getContentType((Message)message)) != null) {
            response.setHeader("Content-Type", (Object)contentType);
            LOG.trace("Content-Type: {}", (Object)contentType);
        }
        if ((connection = (String)message.getHeader("Connection", String.class)) == null) {
            connection = configuration.isKeepAlive() ? "keep-alive" : "close";
        }
        response.setHeader("Connection", (Object)connection);
        LOG.trace("Connection: {}", (Object)connection);
        return response;
    }

    @Override
    public HttpRequest toNettyRequest(Message message, String uri, NettyHttpConfiguration configuration) throws Exception {
        LOG.trace("toNettyRequest: {}", (Object)message);
        if (message.getBody() instanceof HttpRequest) {
            return (HttpRequest)message.getBody();
        }
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, uri);
        TypeConverter tc = message.getExchange().getContext().getTypeConverter();
        Map skipRequestHeaders = null;
        if (configuration.isBridgeEndpoint()) {
            String queryString = (String)message.getHeader("CamelHttpQuery", String.class);
            if (queryString != null) {
                skipRequestHeaders = URISupport.parseQuery((String)queryString);
            }
            message.getHeaders().remove("host");
        }
        for (Map.Entry entry : message.getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (skipRequestHeaders != null && skipRequestHeaders.containsKey(key)) continue;
            Iterator it = ObjectHelper.createIterator(value, null, (boolean)true);
            while (it.hasNext()) {
                String headerValue = (String)tc.convertTo(String.class, it.next());
                if (headerValue == null || this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(key, (Object)headerValue, message.getExchange())) continue;
                LOG.trace("HTTP-Header: {}={}", (Object)key, (Object)headerValue);
                request.addHeader(key, (Object)headerValue);
            }
        }
        Object body = message.getBody();
        if (body != null) {
            ChannelBuffer buffer;
            if (body instanceof ChannelBuffer) {
                buffer = (ChannelBuffer)body;
            } else {
                buffer = (ChannelBuffer)message.getBody(ChannelBuffer.class);
                if (buffer == null) {
                    byte[] data = (byte[])message.getMandatoryBody(byte[].class);
                    buffer = ChannelBuffers.copiedBuffer((byte[])data);
                }
            }
            if (buffer != null) {
                request.setContent(buffer);
                int len = buffer.readableBytes();
                request.setHeader("Content-Length", (Object)len);
                LOG.trace("Content-Length: {}", (Object)len);
            } else {
                throw new NoTypeConversionAvailableException(body, ChannelBuffer.class);
            }
        }
        HttpMethod method = NettyHttpHelper.createMethod(message, body != null);
        request.setMethod(method);
        String contentType = MessageHelper.getContentType((Message)message);
        if (contentType != null) {
            request.setHeader("Content-Type", (Object)contentType);
            LOG.trace("Content-Type: {}", (Object)contentType);
        }
        URI u = new URI(uri);
        String host = u.getHost();
        request.setHeader("Host", (Object)host);
        LOG.trace("Host: {}", (Object)host);
        String connection = (String)message.getHeader("Connection", String.class);
        if (connection == null) {
            connection = configuration.isKeepAlive() ? "keep-alive" : "close";
        }
        request.setHeader("Connection", (Object)connection);
        LOG.trace("Connection: {}", (Object)connection);
        return request;
    }

    @Override
    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    @Override
    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }
}

