/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http.handlers;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.netty.NettyProducer;
import org.apache.camel.component.netty.handlers.ClientChannelHandler;
import org.apache.camel.component.netty.http.NettyHttpProducer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientChannelHandler
extends ClientChannelHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpProducer.class);
    private final NettyHttpProducer producer;
    private HttpResponse response;
    private ChannelBuffer buffer;

    public HttpClientChannelHandler(NettyHttpProducer producer) {
        super((NettyProducer)producer);
        this.producer = producer;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent messageEvent) throws Exception {
        Object msg = messageEvent.getMessage();
        if (msg instanceof HttpChunk) {
            HttpChunk chunk = (HttpChunk)msg;
            if (LOG.isTraceEnabled()) {
                LOG.trace("HttpChunk received: {} isLast: {}", (Object)chunk, (Object)chunk.isLast());
            }
            if (msg instanceof HttpChunkTrailer) {
                HttpChunkTrailer trailer = (HttpChunkTrailer)msg;
                for (Map.Entry entry : trailer.getHeaders()) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Adding trailing header {}={}", entry.getKey(), entry.getValue());
                    }
                    this.response.addHeader((String)entry.getKey(), entry.getValue());
                }
            } else {
                this.buffer.writeBytes(chunk.getContent());
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Wrote {} bytes to chunk buffer", (Object)this.buffer.writerIndex());
                }
            }
            if (chunk.isLast()) {
                int end = this.buffer.writerIndex();
                ChannelBuffer copy = this.buffer.copy(0, end);
                copy.setIndex(end, end);
                this.response.setContent(copy);
                super.messageReceived(ctx, messageEvent);
            }
        } else if (msg instanceof HttpResponse) {
            this.response = (HttpResponse)msg;
            if (LOG.isTraceEnabled()) {
                LOG.trace("HttpResponse received: {} chunked:", (Object)this.response, (Object)this.response.isChunked());
            }
            if (this.response.getStatus().getCode() == HttpResponseStatus.CONTINUE.getCode()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("HttpResponse received: {}: {}", (Object)this.response, (Object)this.response.getStatus());
                }
            } else if (!this.response.isChunked()) {
                super.messageReceived(ctx, messageEvent);
            } else {
                this.buffer = ChannelBuffers.dynamicBuffer();
            }
        } else if (LOG.isTraceEnabled() && msg != null) {
            LOG.trace("Ignoring non supported response message of type {} -> {}", msg.getClass(), msg);
        }
    }

    protected Message getResponseMessage(Exchange exchange, MessageEvent messageEvent) throws Exception {
        return this.producer.getEndpoint().getNettyHttpBinding().toCamelMessage(this.response, exchange, this.producer.getConfiguration());
    }
}

